/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.hardware.camera2.CameraCharacteristics;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.impl.CameraEventCallback;
import androidx.camera.camera2.impl.CameraEventCallbacks;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraX;
import androidx.camera.core.ExtendableBuilder;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraFilter;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ImageInfoProcessor;
import androidx.camera.extensions.AdaptingCaptureStage;
import androidx.camera.extensions.AdaptingPreviewProcessor;
import androidx.camera.extensions.AdaptingRequestUpdateProcessor;
import androidx.camera.extensions.CameraUtil;
import androidx.camera.extensions.ExtensionCameraFilter;
import androidx.camera.extensions.ExtensionVersion;
import androidx.camera.extensions.ExtensionsErrorListener;
import androidx.camera.extensions.ExtensionsManager;
import androidx.camera.extensions.ImageCaptureExtender;
import androidx.camera.extensions.Version;
import androidx.camera.extensions.impl.CaptureStageImpl;
import androidx.camera.extensions.impl.PreviewExtenderImpl;
import androidx.camera.extensions.impl.PreviewImageProcessorImpl;
import java.util.Collection;
import java.util.List;

public abstract class PreviewExtender {
    private static final String TAG = "PreviewExtender";
    static final Config.Option<ExtensionsManager.EffectMode> OPTION_PREVIEW_EXTENDER_MODE = Config.Option.create((String)"camerax.extensions.previewExtender.mode", ExtensionsManager.EffectMode.class);
    private Preview.Builder mBuilder;
    private PreviewExtenderImpl mImpl;
    private ExtensionsManager.EffectMode mEffectMode;
    private ExtensionCameraFilter mExtensionCameraFilter;

    void init(Preview.Builder builder, PreviewExtenderImpl implementation, ExtensionsManager.EffectMode effectMode) {
        this.mBuilder = builder;
        this.mImpl = implementation;
        this.mEffectMode = effectMode;
        this.mExtensionCameraFilter = new ExtensionCameraFilter(this.mImpl);
    }

    public boolean isExtensionAvailable(@NonNull CameraSelector cameraSelector) {
        return this.getCameraWithExtension(cameraSelector) != null;
    }

    private String getCameraWithExtension(@NonNull CameraSelector cameraSelector) {
        CameraSelector.Builder extensionCameraSelectorBuilder = CameraSelector.Builder.fromSelector((CameraSelector)cameraSelector);
        extensionCameraSelectorBuilder.appendFilter((CameraFilter)this.mExtensionCameraFilter);
        return CameraUtil.getCameraIdUnchecked(extensionCameraSelectorBuilder.build());
    }

    public void enableExtension(@NonNull CameraSelector cameraSelector) {
        PreviewExtenderAdapter previewExtenderAdapter;
        String cameraId = this.getCameraWithExtension(cameraSelector);
        if (cameraId == null) {
            return;
        }
        CameraSelector originalSelector = this.mBuilder.getUseCaseConfig().getCameraSelector(null);
        if (originalSelector == null) {
            this.mBuilder.setCameraSelector(new CameraSelector.Builder().appendFilter((CameraFilter)this.mExtensionCameraFilter).build());
        } else {
            this.mBuilder.setCameraSelector(CameraSelector.Builder.fromSelector((CameraSelector)originalSelector).appendFilter((CameraFilter)this.mExtensionCameraFilter).build());
        }
        CameraCharacteristics cameraCharacteristics = CameraUtil.getCameraCharacteristics(cameraId);
        this.mImpl.init(cameraId, cameraCharacteristics);
        switch (this.mImpl.getProcessorType()) {
            case PROCESSOR_TYPE_REQUEST_UPDATE_ONLY: {
                AdaptingRequestUpdateProcessor adaptingRequestUpdateProcessor = new AdaptingRequestUpdateProcessor(this.mImpl);
                this.mBuilder.setImageInfoProcessor((ImageInfoProcessor)adaptingRequestUpdateProcessor);
                previewExtenderAdapter = new PreviewExtenderAdapter(this.mImpl, this.mEffectMode, adaptingRequestUpdateProcessor);
                break;
            }
            case PROCESSOR_TYPE_IMAGE_PROCESSOR: {
                AdaptingPreviewProcessor adaptingPreviewProcessor = new AdaptingPreviewProcessor((PreviewImageProcessorImpl)this.mImpl.getProcessor());
                this.mBuilder.setCaptureProcessor((CaptureProcessor)adaptingPreviewProcessor);
                previewExtenderAdapter = new PreviewExtenderAdapter(this.mImpl, this.mEffectMode, adaptingPreviewProcessor);
                break;
            }
            default: {
                previewExtenderAdapter = new PreviewExtenderAdapter(this.mImpl, this.mEffectMode, null);
            }
        }
        new Camera2ImplConfig.Extender((ExtendableBuilder)this.mBuilder).setCameraEventCallback(new CameraEventCallbacks(new CameraEventCallback[]{previewExtenderAdapter}));
        this.mBuilder.setUseCaseEventCallback((UseCase.EventCallback)previewExtenderAdapter);
        this.mBuilder.getMutableConfig().insertOption(OPTION_PREVIEW_EXTENDER_MODE, (Object)this.mEffectMode);
        this.setSupportedResolutions();
    }

    private void setSupportedResolutions() {
        if (ExtensionVersion.getRuntimeVersion().compareTo(Version.VERSION_1_1) < 0) {
            return;
        }
        List supportedResolutions = null;
        try {
            supportedResolutions = this.mImpl.getSupportedResolutions();
        }
        catch (NoSuchMethodError e) {
            Log.e((String)TAG, (String)"getSupportedResolution interface is not implemented in vendor library.");
        }
        if (supportedResolutions != null) {
            this.mBuilder.setSupportedResolutions(supportedResolutions);
        }
    }

    static void checkImageCaptureEnabled(ExtensionsManager.EffectMode effectMode, Collection<UseCase> activeUseCases) {
        boolean isImageCaptureExtenderEnabled = false;
        boolean isMismatched = false;
        if (activeUseCases == null || activeUseCases.isEmpty()) {
            return;
        }
        for (UseCase useCase : activeUseCases) {
            ExtensionsManager.EffectMode imageCaptureExtenderMode = (ExtensionsManager.EffectMode)((Object)useCase.getUseCaseConfig().retrieveOption(ImageCaptureExtender.OPTION_IMAGE_CAPTURE_EXTENDER_MODE, null));
            if (effectMode == imageCaptureExtenderMode) {
                isImageCaptureExtenderEnabled = true;
                continue;
            }
            if (imageCaptureExtenderMode == null) continue;
            isMismatched = true;
        }
        if (isMismatched) {
            ExtensionsManager.postExtensionsError(ExtensionsErrorListener.ExtensionsErrorCode.MISMATCHED_EXTENSIONS_ENABLED);
        } else if (!isImageCaptureExtenderEnabled) {
            ExtensionsManager.postExtensionsError(ExtensionsErrorListener.ExtensionsErrorCode.IMAGE_CAPTURE_EXTENSION_REQUIRED);
        }
    }

    static interface CloseableProcessor {
        public void close();
    }

    private static class PreviewExtenderAdapter
    extends CameraEventCallback
    implements UseCase.EventCallback {
        final ExtensionsManager.EffectMode mEffectMode;
        final PreviewExtenderImpl mImpl;
        final CloseableProcessor mCloseableProcessor;
        @GuardedBy(value="mLock")
        volatile boolean mActive = true;
        final Object mLock = new Object();
        @GuardedBy(value="mLock")
        private volatile int mEnabledSessionCount = 0;
        @GuardedBy(value="mLock")
        private volatile boolean mUnbind = false;

        PreviewExtenderAdapter(PreviewExtenderImpl impl, ExtensionsManager.EffectMode effectMode, CloseableProcessor closeableProcessor) {
            this.mImpl = impl;
            this.mEffectMode = effectMode;
            this.mCloseableProcessor = closeableProcessor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onBind(@NonNull String cameraId) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mActive) {
                    CameraCharacteristics cameraCharacteristics = CameraUtil.getCameraCharacteristics(cameraId);
                    this.mImpl.onInit(cameraId, cameraCharacteristics, CameraX.getContext());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onUnbind() {
            Object object = this.mLock;
            synchronized (object) {
                this.mUnbind = true;
                if (this.mEnabledSessionCount == 0) {
                    this.callDeInit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void callDeInit() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mActive) {
                    if (this.mCloseableProcessor != null) {
                        this.mCloseableProcessor.close();
                    }
                    this.mImpl.onDeInit();
                    this.mActive = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CaptureConfig onPresetSession() {
            Object object = this.mLock;
            synchronized (object) {
                CaptureStageImpl captureStageImpl;
                if (this.mActive) {
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                PreviewExtender.checkImageCaptureEnabled(mEffectMode, CameraX.getActiveUseCases());
                            }
                            catch (IllegalStateException e) {
                                Log.e((String)PreviewExtender.TAG, (String)"CameraX has been shutdown. Don't need to check for active use cases.");
                            }
                        }
                    });
                }
                if ((captureStageImpl = this.mImpl.onPresetSession()) != null) {
                    return new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public CaptureConfig onEnableSession() {
            Object object;
            block12: {
                CaptureConfig captureConfig;
                try {
                    CaptureStageImpl captureStageImpl;
                    object = this.mLock;
                    // MONITORENTER : object
                    if (!this.mActive || (captureStageImpl = this.mImpl.onEnableSession()) == null) break block12;
                    captureConfig = new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                    // MONITOREXIT : object
                    Object object2 = this.mLock;
                }
                catch (Throwable throwable) {
                    Object object3 = this.mLock;
                    // MONITORENTER : object3
                    ++this.mEnabledSessionCount;
                    // MONITOREXIT : object3
                    throw throwable;
                }
                ++this.mEnabledSessionCount;
                // MONITOREXIT : object2
                return captureConfig;
            }
            // MONITOREXIT : object
            object = null;
            Object object4 = this.mLock;
            ++this.mEnabledSessionCount;
            // MONITOREXIT : object4
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public CaptureConfig onDisableSession() {
            Object object;
            block15: {
                CaptureConfig captureConfig;
                try {
                    CaptureStageImpl captureStageImpl;
                    object = this.mLock;
                    // MONITORENTER : object
                    if (!this.mActive || (captureStageImpl = this.mImpl.onDisableSession()) == null) break block15;
                    captureConfig = new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                    // MONITOREXIT : object
                    Object object2 = this.mLock;
                }
                catch (Throwable throwable) {
                    Object object3 = this.mLock;
                    // MONITORENTER : object3
                    --this.mEnabledSessionCount;
                    if (this.mEnabledSessionCount == 0 && this.mUnbind) {
                        this.callDeInit();
                    }
                    // MONITOREXIT : object3
                    throw throwable;
                }
                --this.mEnabledSessionCount;
                if (this.mEnabledSessionCount == 0 && this.mUnbind) {
                    this.callDeInit();
                }
                // MONITOREXIT : object2
                return captureConfig;
            }
            // MONITOREXIT : object
            object = null;
            Object object4 = this.mLock;
            --this.mEnabledSessionCount;
            if (this.mEnabledSessionCount == 0 && this.mUnbind) {
                this.callDeInit();
            }
            // MONITOREXIT : object4
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CaptureConfig onRepeating() {
            Object object = this.mLock;
            synchronized (object) {
                CaptureStageImpl captureStageImpl;
                if (this.mActive && (captureStageImpl = this.mImpl.getCaptureStage()) != null) {
                    return new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                }
            }
            return null;
        }
    }
}

