/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import androidx.annotation.NonNull;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.Logger;
import androidx.camera.core.Preview;
import androidx.camera.extensions.ExtensionVersion;
import androidx.camera.extensions.PreviewExtender;
import androidx.camera.extensions.impl.AutoPreviewExtenderImpl;
import androidx.camera.extensions.impl.PreviewExtenderImpl;

public class AutoPreviewExtender
extends PreviewExtender {
    private static final String TAG = "AutoPreviewExtender";

    @NonNull
    public static AutoPreviewExtender create(@NonNull Preview.Builder builder) {
        if (ExtensionVersion.isExtensionVersionSupported()) {
            try {
                return new VendorAutoPreviewExtender(builder);
            }
            catch (NoClassDefFoundError e) {
                Logger.d((String)TAG, (String)"No auto preview extender found. Falling back to default.");
            }
        }
        return new DefaultAutoPreviewExtender();
    }

    private AutoPreviewExtender() {
    }

    static class VendorAutoPreviewExtender
    extends AutoPreviewExtender {
        private final AutoPreviewExtenderImpl mImpl = new AutoPreviewExtenderImpl();

        VendorAutoPreviewExtender(Preview.Builder builder) {
            this.init(builder, (PreviewExtenderImpl)this.mImpl, 5);
        }
    }

    static class DefaultAutoPreviewExtender
    extends AutoPreviewExtender {
        DefaultAutoPreviewExtender() {
        }

        @Override
        public boolean isExtensionAvailable(@NonNull CameraSelector selector) {
            return false;
        }

        @Override
        public void enableExtension(@NonNull CameraSelector selector) {
        }
    }
}

