/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import androidx.annotation.NonNull;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.Logger;
import androidx.camera.core.Preview;
import androidx.camera.extensions.ExtensionVersion;
import androidx.camera.extensions.PreviewExtender;
import androidx.camera.extensions.impl.BeautyPreviewExtenderImpl;
import androidx.camera.extensions.impl.PreviewExtenderImpl;

public class BeautyPreviewExtender
extends PreviewExtender {
    private static final String TAG = "BeautyPreviewExtender";

    @NonNull
    public static BeautyPreviewExtender create(@NonNull Preview.Builder builder) {
        if (ExtensionVersion.isExtensionVersionSupported()) {
            try {
                return new VendorBeautyPreviewExtender(builder);
            }
            catch (NoClassDefFoundError e) {
                Logger.d((String)TAG, (String)"No beauty preview extender found. Falling back to default.");
            }
        }
        return new DefaultBeautyPreviewExtender();
    }

    private BeautyPreviewExtender() {
    }

    static class VendorBeautyPreviewExtender
    extends BeautyPreviewExtender {
        private final BeautyPreviewExtenderImpl mImpl = new BeautyPreviewExtenderImpl();

        VendorBeautyPreviewExtender(Preview.Builder builder) {
            this.init(builder, (PreviewExtenderImpl)this.mImpl, 4);
        }
    }

    static class DefaultBeautyPreviewExtender
    extends BeautyPreviewExtender {
        DefaultBeautyPreviewExtender() {
        }

        @Override
        public boolean isExtensionAvailable(@NonNull CameraSelector selector) {
            return false;
        }

        @Override
        public void enableExtension(@NonNull CameraSelector selector) {
        }
    }
}

