/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraX;
import androidx.camera.core.Logger;
import androidx.core.util.Preconditions;

class CameraUtil {
    private static final String TAG = "CameraUtil";

    @Nullable
    static String getCameraIdUnchecked(@NonNull CameraSelector cameraSelector) {
        try {
            return CameraX.getCameraWithCameraSelector((CameraSelector)cameraSelector).getCameraInfoInternal().getCameraId();
        }
        catch (IllegalArgumentException e) {
            Logger.w((String)TAG, (String)"Unable to get camera id for the camera selector.");
            return null;
        }
    }

    @Nullable
    static String getCameraIdWithLensFacingUnchecked(@Nullable Integer lensFacing) {
        CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(lensFacing.intValue()).build();
        return CameraUtil.getCameraIdUnchecked(cameraSelector);
    }

    static CameraCharacteristics getCameraCharacteristics(String cameraId) {
        Preconditions.checkNotNull((Object)cameraId, (Object)"Invalid camera id.");
        Context context = CameraX.getContext();
        CameraManagerCompat cameraManager = CameraManagerCompat.from((Context)context);
        CameraCharacteristics cameraCharacteristics = null;
        try {
            cameraCharacteristics = cameraManager.getCameraCharacteristicsCompat(cameraId).toCameraCharacteristics();
        }
        catch (CameraAccessExceptionCompat e) {
            throw new IllegalArgumentException("Unable to retrieve info for camera with id " + cameraId + ".", e);
        }
        return cameraCharacteristics;
    }

    private CameraUtil() {
    }
}

