/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import androidx.annotation.NonNull;
import androidx.camera.core.CameraFilter;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.ReadableConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;

class ExtensionsConfig
implements ReadableConfig,
CameraConfig {
    public static final Config.Option<Integer> OPTION_EXTENSION_MODE = Config.Option.create((String)"camerax.extensions.extensionMode", Integer.TYPE);
    private final Config mConfig;

    ExtensionsConfig(Config config) {
        this.mConfig = config;
    }

    @NonNull
    public Config getConfig() {
        return this.mConfig;
    }

    public int getExtensionMode() {
        return (Integer)this.retrieveOption(OPTION_EXTENSION_MODE);
    }

    @NonNull
    public UseCaseConfigFactory getUseCaseConfigFactory() {
        return (UseCaseConfigFactory)this.retrieveOption(OPTION_USECASE_CONFIG_FACTORY);
    }

    static final class Builder
    implements CameraConfig.Builder<Builder> {
        private final MutableOptionsBundle mConfig = MutableOptionsBundle.create();

        Builder() {
        }

        ExtensionsConfig build() {
            return new ExtensionsConfig((Config)this.mConfig);
        }

        public Builder setExtensionMode(int mode) {
            this.mConfig.insertOption(OPTION_EXTENSION_MODE, (Object)mode);
            return this;
        }

        @NonNull
        public Builder setCameraFilter(@NonNull CameraFilter cameraFilter) {
            this.mConfig.insertOption(CameraConfig.OPTION_CAMERA_FILTER, (Object)cameraFilter);
            return this;
        }

        @NonNull
        public Builder setUseCaseConfigFactory(@NonNull UseCaseConfigFactory factory) {
            this.mConfig.insertOption(CameraConfig.OPTION_USECASE_CONFIG_FACTORY, (Object)factory);
            return this;
        }
    }
}

