/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import androidx.camera.core.Preview;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.extensions.AutoImageCaptureExtender;
import androidx.camera.extensions.AutoPreviewExtender;
import androidx.camera.extensions.BeautyImageCaptureExtender;
import androidx.camera.extensions.BeautyPreviewExtender;
import androidx.camera.extensions.BokehImageCaptureExtender;
import androidx.camera.extensions.BokehPreviewExtender;
import androidx.camera.extensions.ExtensionVersion;
import androidx.camera.extensions.Extensions;
import androidx.camera.extensions.ExtensionsErrorListener;
import androidx.camera.extensions.HdrImageCaptureExtender;
import androidx.camera.extensions.HdrPreviewExtender;
import androidx.camera.extensions.ImageCaptureExtender;
import androidx.camera.extensions.NightImageCaptureExtender;
import androidx.camera.extensions.NightPreviewExtender;
import androidx.camera.extensions.PreviewExtender;
import androidx.camera.extensions.Version;
import androidx.camera.extensions.VersionName;
import androidx.camera.extensions.impl.InitializerImpl;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

public final class ExtensionsManager {
    private static final String TAG = "ExtensionsManager";
    private static final Object ERROR_LOCK = new Object();
    @GuardedBy(value="ERROR_LOCK")
    private static final Handler DEFAULT_HANDLER = new Handler(Looper.getMainLooper());
    @GuardedBy(value="ERROR_LOCK")
    private static volatile ExtensionsErrorListener sExtensionsErrorListener = null;
    private static final Object EXTENSIONS_LOCK = new Object();
    @GuardedBy(value="EXTENSIONS_LOCK")
    static boolean sInitialized = false;
    @GuardedBy(value="EXTENSIONS_LOCK")
    private static ListenableFuture<ExtensionsAvailability> sAvailabilityFuture;
    @GuardedBy(value="EXTENSIONS_LOCK")
    private static ListenableFuture<Void> sDeinitFuture;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ListenableFuture<ExtensionsAvailability> init(@NonNull Context context) {
        Object object = EXTENSIONS_LOCK;
        synchronized (object) {
            if (sDeinitFuture != null && !sDeinitFuture.isDone()) {
                throw new IllegalStateException("Not yet done deinitializing extensions");
            }
            sDeinitFuture = null;
            if (ExtensionVersion.getRuntimeVersion() == null) {
                ExtensionsManager.setInitialized(true);
                return Futures.immediateFuture((Object)((Object)ExtensionsAvailability.NONE));
            }
            if (ExtensionVersion.getRuntimeVersion().compareTo(Version.VERSION_1_1) < 0) {
                ExtensionsManager.setInitialized(true);
                return Futures.immediateFuture((Object)((Object)ExtensionsAvailability.LIBRARY_AVAILABLE));
            }
            if (sAvailabilityFuture == null) {
                sAvailabilityFuture = CallbackToFutureAdapter.getFuture(completer -> {
                    try {
                        InitializerImpl.init((String)VersionName.getCurrentVersion().toVersionString(), (Context)context, (InitializerImpl.OnExtensionsInitializedCallback)new InitializerImpl.OnExtensionsInitializedCallback(){

                            public void onSuccess() {
                                Logger.d((String)ExtensionsManager.TAG, (String)"Successfully initialized extensions");
                                ExtensionsManager.setInitialized(true);
                                completer.set((Object)ExtensionsAvailability.LIBRARY_AVAILABLE);
                            }

                            public void onFailure(int error) {
                                Logger.d((String)ExtensionsManager.TAG, (String)"Failed to initialize extensions");
                                completer.set((Object)ExtensionsAvailability.LIBRARY_UNAVAILABLE_ERROR_LOADING);
                            }
                        }, (Executor)CameraXExecutors.mainThreadExecutor());
                    }
                    catch (NoClassDefFoundError | NoSuchMethodError e) {
                        completer.set((Object)ExtensionsAvailability.LIBRARY_UNAVAILABLE_MISSING_IMPLEMENTATION);
                    }
                    return "Initialize extensions";
                });
            }
            return sAvailabilityFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setInitialized(boolean initialized) {
        Object object = EXTENSIONS_LOCK;
        synchronized (object) {
            sInitialized = initialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    @NonNull
    public static ListenableFuture<Void> deinit() {
        Object object = EXTENSIONS_LOCK;
        synchronized (object) {
            ExtensionsAvailability availability;
            ExtensionsManager.setInitialized(false);
            if (ExtensionVersion.getRuntimeVersion() == null) {
                return Futures.immediateFuture(null);
            }
            if (sAvailabilityFuture == null) {
                return Futures.immediateFuture(null);
            }
            if (sDeinitFuture != null) {
                return sDeinitFuture;
            }
            try {
                availability = (ExtensionsAvailability)((Object)sAvailabilityFuture.get());
            }
            catch (InterruptedException | ExecutionException e) {
                sDeinitFuture = Futures.immediateFailedFuture((Throwable)e);
                return sDeinitFuture;
            }
            sAvailabilityFuture = null;
            sDeinitFuture = availability == ExtensionsAvailability.LIBRARY_AVAILABLE ? CallbackToFutureAdapter.getFuture(completer -> {
                try {
                    InitializerImpl.deinit((InitializerImpl.OnExtensionsDeinitializedCallback)new InitializerImpl.OnExtensionsDeinitializedCallback(){

                        public void onSuccess() {
                            completer.set(null);
                        }

                        public void onFailure(int error) {
                            completer.setException((Throwable)new Exception("Failed to deinitialize extensions."));
                        }
                    }, (Executor)CameraXExecutors.mainThreadExecutor());
                }
                catch (NoClassDefFoundError | NoSuchMethodError e) {
                    completer.setException((Throwable)e);
                }
                return null;
            }) : Futures.immediateFuture(null);
            return sDeinitFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static Extensions getExtensions(@NonNull Context context) {
        Object object = EXTENSIONS_LOCK;
        synchronized (object) {
            if (!sInitialized) {
                throw new IllegalStateException("Extensions not yet initialized");
            }
            return new Extensions(context);
        }
    }

    public static boolean isExtensionAvailable(@NonNull EffectMode effectMode, int lensFacing) {
        boolean isPreviewAvailable;
        boolean isImageCaptureAvailable = ExtensionsManager.checkImageCaptureExtensionCapability(effectMode, lensFacing);
        if (isImageCaptureAvailable != (isPreviewAvailable = ExtensionsManager.checkPreviewExtensionCapability(effectMode, lensFacing))) {
            Logger.e((String)TAG, (String)("ImageCapture and Preview are not available simultaneously for " + effectMode.name()));
        }
        return isImageCaptureAvailable && isPreviewAvailable;
    }

    public static boolean isExtensionAvailable(@NonNull Class<?> klass, @NonNull EffectMode effectMode, int lensFacing) {
        boolean isAvailable = false;
        if (klass == ImageCapture.class) {
            isAvailable = ExtensionsManager.checkImageCaptureExtensionCapability(effectMode, lensFacing);
        } else if (klass.equals(Preview.class)) {
            isAvailable = ExtensionsManager.checkPreviewExtensionCapability(effectMode, lensFacing);
        }
        return isAvailable;
    }

    private static boolean checkImageCaptureExtensionCapability(EffectMode effectMode, int lensFacing) {
        ImageCaptureExtender extender;
        ImageCapture.Builder builder = new ImageCapture.Builder();
        CameraSelector selector = new CameraSelector.Builder().requireLensFacing(lensFacing).build();
        switch (effectMode) {
            case BOKEH: {
                extender = BokehImageCaptureExtender.create(builder);
                break;
            }
            case HDR: {
                extender = HdrImageCaptureExtender.create(builder);
                break;
            }
            case NIGHT: {
                extender = NightImageCaptureExtender.create(builder);
                break;
            }
            case BEAUTY: {
                extender = BeautyImageCaptureExtender.create(builder);
                break;
            }
            case AUTO: {
                extender = AutoImageCaptureExtender.create(builder);
                break;
            }
            case NORMAL: {
                return true;
            }
            default: {
                return false;
            }
        }
        return extender.isExtensionAvailable(selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExtensionsErrorListener(@Nullable ExtensionsErrorListener listener) {
        Object object = ERROR_LOCK;
        synchronized (object) {
            sExtensionsErrorListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void postExtensionsError(final ExtensionsErrorListener.ExtensionsErrorCode errorCode) {
        Object object = ERROR_LOCK;
        synchronized (object) {
            final ExtensionsErrorListener listenerReference = sExtensionsErrorListener;
            if (listenerReference != null) {
                DEFAULT_HANDLER.post(new Runnable(){

                    @Override
                    public void run() {
                        listenerReference.onError(errorCode);
                    }
                });
            }
        }
    }

    private static boolean checkPreviewExtensionCapability(EffectMode effectMode, int lensFacing) {
        PreviewExtender extender;
        Preview.Builder builder = new Preview.Builder();
        CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(lensFacing).build();
        switch (effectMode) {
            case BOKEH: {
                extender = BokehPreviewExtender.create(builder);
                break;
            }
            case HDR: {
                extender = HdrPreviewExtender.create(builder);
                break;
            }
            case NIGHT: {
                extender = NightPreviewExtender.create(builder);
                break;
            }
            case BEAUTY: {
                extender = BeautyPreviewExtender.create(builder);
                break;
            }
            case AUTO: {
                extender = AutoPreviewExtender.create(builder);
                break;
            }
            case NORMAL: {
                return true;
            }
            default: {
                return false;
            }
        }
        return extender.isExtensionAvailable(cameraSelector);
    }

    private ExtensionsManager() {
    }

    public static enum ExtensionsAvailability {
        LIBRARY_AVAILABLE,
        LIBRARY_UNAVAILABLE_ERROR_LOADING,
        LIBRARY_UNAVAILABLE_MISSING_IMPLEMENTATION,
        NONE;

    }

    public static enum EffectMode {
        NORMAL,
        BOKEH,
        HDR,
        NIGHT,
        BEAUTY,
        AUTO;

    }
}

