/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.os.Build;
import android.util.Pair;
import android.util.Size;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.impl.CameraEventCallback;
import androidx.camera.camera2.impl.CameraEventCallbacks;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraFilter;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraX;
import androidx.camera.core.ExperimentalCameraFilter;
import androidx.camera.core.ExtendableBuilder;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CaptureBundle;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.CaptureStage;
import androidx.camera.core.impl.Config;
import androidx.camera.extensions.CameraUtil;
import androidx.camera.extensions.ExtensionCameraFilter;
import androidx.camera.extensions.ExtensionVersion;
import androidx.camera.extensions.ExtensionsErrorListener;
import androidx.camera.extensions.ExtensionsManager;
import androidx.camera.extensions.PreviewExtender;
import androidx.camera.extensions.Version;
import androidx.camera.extensions.impl.CaptureProcessorImpl;
import androidx.camera.extensions.impl.CaptureStageImpl;
import androidx.camera.extensions.impl.ImageCaptureExtenderImpl;
import androidx.camera.extensions.internal.AdaptingCaptureProcessor;
import androidx.camera.extensions.internal.AdaptingCaptureStage;
import androidx.core.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ImageCaptureExtender {
    private static final String TAG = "ImageCaptureExtender";
    static final Config.Option<Integer> OPTION_IMAGE_CAPTURE_EXTENDER_MODE = Config.Option.create((String)"camerax.extensions.imageCaptureExtender.mode", Integer.class);
    private ImageCapture.Builder mBuilder;
    private ImageCaptureExtenderImpl mImpl;
    private int mEffectMode;
    private ExtensionCameraFilter mExtensionCameraFilter;

    @OptIn(markerClass={ExperimentalCameraFilter.class})
    void init(ImageCapture.Builder builder, ImageCaptureExtenderImpl implementation, int effectMode) {
        this.mBuilder = builder;
        this.mImpl = implementation;
        this.mEffectMode = effectMode;
        this.mExtensionCameraFilter = new ExtensionCameraFilter(this.mImpl);
    }

    public boolean isExtensionAvailable(@NonNull CameraSelector cameraSelector) {
        return this.getCameraWithExtension(cameraSelector) != null;
    }

    @OptIn(markerClass={ExperimentalCameraFilter.class})
    private String getCameraWithExtension(@NonNull CameraSelector cameraSelector) {
        CameraSelector.Builder extensionCameraSelectorBuilder = CameraSelector.Builder.fromSelector((CameraSelector)cameraSelector);
        extensionCameraSelectorBuilder.addCameraFilter((CameraFilter)this.mExtensionCameraFilter);
        return CameraUtil.getCameraIdUnchecked(extensionCameraSelectorBuilder.build());
    }

    @OptIn(markerClass={ExperimentalCameraFilter.class})
    public void enableExtension(@NonNull CameraSelector cameraSelector) {
        String cameraId = this.getCameraWithExtension(cameraSelector);
        if (cameraId == null) {
            return;
        }
        CameraSelector originalSelector = this.mBuilder.getUseCaseConfig().getCameraSelector(null);
        if (originalSelector == null) {
            this.mBuilder.setCameraSelector(new CameraSelector.Builder().addCameraFilter((CameraFilter)this.mExtensionCameraFilter).build());
        } else {
            this.mBuilder.setCameraSelector(CameraSelector.Builder.fromSelector((CameraSelector)originalSelector).addCameraFilter((CameraFilter)this.mExtensionCameraFilter).build());
        }
        CameraCharacteristics cameraCharacteristics = CameraUtil.getCameraCharacteristics(cameraId);
        this.mImpl.init(cameraId, cameraCharacteristics);
        Context context = CameraX.getContext();
        ImageCaptureExtender.updateBuilderConfig(this.mBuilder, this.mEffectMode, this.mImpl, context);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void updateBuilderConfig(@NonNull ImageCapture.Builder builder, int effectMode, @NonNull ImageCaptureExtenderImpl impl, @NonNull Context context) {
        CaptureProcessorImpl captureProcessor = impl.getCaptureProcessor();
        if (captureProcessor != null) {
            builder.setCaptureProcessor((CaptureProcessor)new AdaptingCaptureProcessor(captureProcessor));
        }
        if (impl.getMaxCaptureStage() > 0) {
            builder.setMaxCaptureStages(impl.getMaxCaptureStage());
        }
        ImageCaptureAdapter imageCaptureAdapter = new ImageCaptureAdapter(impl, context);
        new Camera2ImplConfig.Extender((ExtendableBuilder)builder).setCameraEventCallback(new CameraEventCallbacks(new CameraEventCallback[]{imageCaptureAdapter}));
        builder.setUseCaseEventCallback((UseCase.EventCallback)imageCaptureAdapter);
        try {
            Consumer attachedUseCasesUpdateListener = useCases -> ImageCaptureExtender.checkPreviewEnabled(effectMode, useCases);
            builder.setAttachedUseCasesUpdateListener(attachedUseCasesUpdateListener);
        }
        catch (NoSuchMethodError e) {
            Logger.e((String)TAG, (String)"Can't set attached use cases update listener.");
        }
        builder.setCaptureBundle((CaptureBundle)imageCaptureAdapter);
        builder.getMutableConfig().insertOption(OPTION_IMAGE_CAPTURE_EXTENDER_MODE, (Object)effectMode);
        List<Pair<Integer, Size[]>> supportedResolutions = ImageCaptureExtender.getSupportedResolutions(impl);
        if (supportedResolutions != null) {
            builder.setSupportedResolutions(supportedResolutions);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public static List<Pair<Integer, Size[]>> getSupportedResolutions(@NonNull ImageCaptureExtenderImpl impl) {
        if (ExtensionVersion.getRuntimeVersion().compareTo(Version.VERSION_1_1) < 0) {
            return null;
        }
        try {
            return impl.getSupportedResolutions();
        }
        catch (NoSuchMethodError e) {
            Logger.e((String)TAG, (String)"getSupportedResolution interface is not implemented in vendor library.");
            return null;
        }
    }

    static void checkPreviewEnabled(int effectMode, Collection<UseCase> activeUseCases) {
        boolean isPreviewExtenderEnabled = false;
        boolean isMismatched = false;
        if (activeUseCases == null || activeUseCases.isEmpty()) {
            return;
        }
        for (UseCase useCase : activeUseCases) {
            int previewExtenderMode = (Integer)useCase.getCurrentConfig().retrieveOption(PreviewExtender.OPTION_PREVIEW_EXTENDER_MODE, (Object)0);
            if (effectMode == previewExtenderMode) {
                isPreviewExtenderEnabled = true;
                continue;
            }
            if (previewExtenderMode == 0) continue;
            isMismatched = true;
        }
        if (isMismatched) {
            ExtensionsManager.postExtensionsError(ExtensionsErrorListener.ExtensionsErrorCode.MISMATCHED_EXTENSIONS_ENABLED);
        } else if (!isPreviewExtenderEnabled) {
            ExtensionsManager.postExtensionsError(ExtensionsErrorListener.ExtensionsErrorCode.PREVIEW_EXTENSION_REQUIRED);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static class ImageCaptureAdapter
    extends CameraEventCallback
    implements UseCase.EventCallback,
    CaptureBundle {
        @NonNull
        private final ImageCaptureExtenderImpl mImpl;
        @NonNull
        private final Context mContext;
        private final AtomicBoolean mActive = new AtomicBoolean(true);
        private final Object mLock = new Object();
        @GuardedBy(value="mLock")
        private volatile int mEnabledSessionCount = 0;
        @GuardedBy(value="mLock")
        private volatile boolean mUnbind = false;

        public ImageCaptureAdapter(@NonNull ImageCaptureExtenderImpl impl, @NonNull Context context) {
            this.mImpl = impl;
            this.mContext = context;
        }

        @OptIn(markerClass={ExperimentalCamera2Interop.class})
        public void onAttach(@NonNull CameraInfo cameraInfo) {
            if (this.mActive.get()) {
                String cameraId = Camera2CameraInfo.from((CameraInfo)cameraInfo).getCameraId();
                CameraCharacteristics cameraCharacteristics = Camera2CameraInfo.extractCameraCharacteristics((CameraInfo)cameraInfo);
                this.mImpl.onInit(cameraId, cameraCharacteristics, this.mContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDetach() {
            Object object = this.mLock;
            synchronized (object) {
                this.mUnbind = true;
                if (this.mEnabledSessionCount == 0) {
                    this.callDeInit();
                }
            }
        }

        private void callDeInit() {
            if (this.mActive.get()) {
                this.mImpl.onDeInit();
                this.mActive.set(false);
            }
        }

        @Nullable
        public CaptureConfig onPresetSession() {
            CaptureStageImpl captureStageImpl;
            if (this.mActive.get() && (captureStageImpl = this.mImpl.onPresetSession()) != null) {
                if (Build.VERSION.SDK_INT >= 28) {
                    return new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                }
                Logger.w((String)ImageCaptureExtender.TAG, (String)"The CaptureRequest parameters returned from onPresetSession() will be passed to the camera device as part of the capture session via SessionConfiguration#setSessionParameters(CaptureRequest) which only supported from API level 28!");
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public CaptureConfig onEnableSession() {
            try {
                CaptureStageImpl captureStageImpl;
                if (this.mActive.get() && (captureStageImpl = this.mImpl.onEnableSession()) != null) {
                    CaptureConfig captureConfig = new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                    return captureConfig;
                }
                CaptureConfig captureConfig = null;
                return captureConfig;
            }
            finally {
                Object object = this.mLock;
                synchronized (object) {
                    ++this.mEnabledSessionCount;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public CaptureConfig onDisableSession() {
            try {
                CaptureStageImpl captureStageImpl;
                if (this.mActive.get() && (captureStageImpl = this.mImpl.onDisableSession()) != null) {
                    CaptureConfig captureConfig = new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                    return captureConfig;
                }
                CaptureConfig captureConfig = null;
                return captureConfig;
            }
            finally {
                Object object = this.mLock;
                synchronized (object) {
                    --this.mEnabledSessionCount;
                    if (this.mEnabledSessionCount == 0 && this.mUnbind) {
                        this.callDeInit();
                    }
                }
            }
        }

        @Nullable
        public List<CaptureStage> getCaptureStages() {
            List captureStages;
            if (this.mActive.get() && (captureStages = this.mImpl.getCaptureStages()) != null && !captureStages.isEmpty()) {
                ArrayList<CaptureStage> ret = new ArrayList<CaptureStage>();
                for (CaptureStageImpl s : captureStages) {
                    ret.add(new AdaptingCaptureStage(s));
                }
                return ret;
            }
            return null;
        }
    }
}

