/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.extensions.internal.ImageCaptureConfigProvider;
import androidx.camera.extensions.internal.PreviewConfigProvider;

public final class ExtensionsUseCaseConfigFactory
implements UseCaseConfigFactory {
    private final ImageCaptureConfigProvider mImageCaptureConfigProvider;
    private final PreviewConfigProvider mPreviewConfigProvider;

    public ExtensionsUseCaseConfigFactory(int mode, @NonNull CameraInfo cameraInfo, @NonNull Context context) {
        this.mImageCaptureConfigProvider = new ImageCaptureConfigProvider(mode, cameraInfo, context);
        this.mPreviewConfigProvider = new PreviewConfigProvider(mode, cameraInfo, context);
    }

    @Nullable
    public Config getConfig(@NonNull UseCaseConfigFactory.CaptureType captureType) {
        MutableOptionsBundle mutableOptionsBundle;
        switch (captureType) {
            case IMAGE_CAPTURE: {
                mutableOptionsBundle = MutableOptionsBundle.from((Config)this.mImageCaptureConfigProvider.getConfig());
                break;
            }
            case PREVIEW: {
                mutableOptionsBundle = MutableOptionsBundle.from((Config)this.mPreviewConfigProvider.getConfig());
                break;
            }
            default: {
                return null;
            }
        }
        return OptionsBundle.from((Config)mutableOptionsBundle);
    }
}

