/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.lifecycle;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraControl;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.internal.CameraUseCaseAdapter;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

final class LifecycleCamera
implements LifecycleObserver,
Camera {
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private final LifecycleOwner mLifecycleOwner;
    private final CameraUseCaseAdapter mCameraUseCaseAdapter;
    @GuardedBy(value="mLock")
    private volatile boolean mIsActive = false;
    @GuardedBy(value="mLock")
    private boolean mSuspended = false;
    @GuardedBy(value="mLock")
    private boolean mReleased = false;

    LifecycleCamera(LifecycleOwner lifecycleOwner, CameraUseCaseAdapter cameraUseCaseAdaptor) {
        this.mLifecycleOwner = lifecycleOwner;
        this.mCameraUseCaseAdapter = cameraUseCaseAdaptor;
        if (this.mLifecycleOwner.getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.STARTED)) {
            this.mCameraUseCaseAdapter.attachUseCases();
        } else {
            this.mCameraUseCaseAdapter.detachUseCases();
        }
        lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    public void onStart(LifecycleOwner lifecycleOwner) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mSuspended && !this.mReleased) {
                this.mCameraUseCaseAdapter.attachUseCases();
                this.mIsActive = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public void onStop(LifecycleOwner lifecycleOwner) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mSuspended && !this.mReleased) {
                this.mCameraUseCaseAdapter.detachUseCases();
                this.mIsActive = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onDestroy(LifecycleOwner lifecycleOwner) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCameraUseCaseAdapter.removeUseCases((Collection)this.mCameraUseCaseAdapter.getUseCases());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSuspended) {
                return;
            }
            this.onStop(this.mLifecycleOwner);
            this.mSuspended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsuspend() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mSuspended) {
                return;
            }
            this.mSuspended = false;
            if (this.mLifecycleOwner.getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.STARTED)) {
                this.onStart(this.mLifecycleOwner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIsActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBound(@NonNull UseCase useCase) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCameraUseCaseAdapter.getUseCases().contains(useCase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<UseCase> getUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            return Collections.unmodifiableList(this.mCameraUseCaseAdapter.getUseCases());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LifecycleOwner getLifecycleOwner() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mLifecycleOwner;
        }
    }

    public CameraUseCaseAdapter getCameraUseCaseAdapter() {
        return this.mCameraUseCaseAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bind(Collection<UseCase> useCases) throws CameraUseCaseAdapter.CameraException {
        Object object = this.mLock;
        synchronized (object) {
            this.mCameraUseCaseAdapter.addUseCases(useCases);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unbind(Collection<UseCase> useCases) {
        Object object = this.mLock;
        synchronized (object) {
            ArrayList<UseCase> useCasesToRemove = new ArrayList<UseCase>(useCases);
            useCasesToRemove.retainAll(this.mCameraUseCaseAdapter.getUseCases());
            this.mCameraUseCaseAdapter.removeUseCases(useCasesToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unbindAll() {
        Object object = this.mLock;
        synchronized (object) {
            this.mCameraUseCaseAdapter.removeUseCases((Collection)this.mCameraUseCaseAdapter.getUseCases());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        Object object = this.mLock;
        synchronized (object) {
            this.mReleased = true;
            this.mIsActive = false;
            this.mLifecycleOwner.getLifecycle().removeObserver((LifecycleObserver)this);
        }
    }

    @NonNull
    public CameraControl getCameraControl() {
        return this.mCameraUseCaseAdapter.getCameraControl();
    }

    @NonNull
    public CameraInfo getCameraInfo() {
        return this.mCameraUseCaseAdapter.getCameraInfo();
    }

    @NonNull
    public LinkedHashSet<CameraInternal> getCameraInternals() {
        return this.mCameraUseCaseAdapter.getCameraInternals();
    }

    @NonNull
    public CameraConfig getExtendedConfig() {
        return this.mCameraUseCaseAdapter.getExtendedConfig();
    }

    public void setExtendedConfig(@Nullable CameraConfig cameraConfig) throws CameraUseCaseAdapter.CameraException {
        this.mCameraUseCaseAdapter.setExtendedConfig(cameraConfig);
    }
}

