/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.lifecycle;

import android.content.Context;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraEffect;
import androidx.camera.core.CameraFilter;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraInfoUnavailableException;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraX;
import androidx.camera.core.CameraXConfig;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseGroup;
import androidx.camera.core.ViewPort;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.ExtendedCameraConfigProviderStore;
import androidx.camera.core.impl.utils.ContextUtil;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.internal.CameraUseCaseAdapter;
import androidx.camera.lifecycle.ExperimentalCameraProviderConfiguration;
import androidx.camera.lifecycle.LifecycleCamera;
import androidx.camera.lifecycle.LifecycleCameraProvider;
import androidx.camera.lifecycle.LifecycleCameraRepository;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LifecycleOwner;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public final class ProcessCameraProvider
implements LifecycleCameraProvider {
    private static final ProcessCameraProvider sAppInstance = new ProcessCameraProvider();
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private CameraXConfig.Provider mCameraXConfigProvider = null;
    @GuardedBy(value="mLock")
    private ListenableFuture<CameraX> mCameraXInitializeFuture;
    @GuardedBy(value="mLock")
    private ListenableFuture<Void> mCameraXShutdownFuture = Futures.immediateFuture(null);
    private final LifecycleCameraRepository mLifecycleCameraRepository = new LifecycleCameraRepository();
    private CameraX mCameraX;
    private Context mContext;

    @NonNull
    public static ListenableFuture<ProcessCameraProvider> getInstance(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        return Futures.transform(sAppInstance.getOrCreateCameraXInstance(context), cameraX -> {
            sAppInstance.setCameraX((CameraX)cameraX);
            sAppInstance.setContext(ContextUtil.getApplicationContext((Context)context));
            return sAppInstance;
        }, (Executor)CameraXExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture<CameraX> getOrCreateCameraXInstance(@NonNull Context context) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCameraXInitializeFuture != null) {
                return this.mCameraXInitializeFuture;
            }
            final CameraX cameraX = new CameraX(context, this.mCameraXConfigProvider);
            this.mCameraXInitializeFuture = CallbackToFutureAdapter.getFuture(completer -> {
                Object object = this.mLock;
                synchronized (object) {
                    FutureChain future = FutureChain.from(this.mCameraXShutdownFuture).transformAsync(input -> cameraX.getInitializeFuture(), CameraXExecutors.directExecutor());
                    Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Void>(){

                        public void onSuccess(@Nullable Void result) {
                            completer.set((Object)cameraX);
                        }

                        public void onFailure(@NonNull Throwable t) {
                            completer.setException(t);
                        }
                    }, (Executor)CameraXExecutors.directExecutor());
                }
                return "ProcessCameraProvider-initializeCameraX";
            });
            return this.mCameraXInitializeFuture;
        }
    }

    @ExperimentalCameraProviderConfiguration
    public static void configureInstance(@NonNull CameraXConfig cameraXConfig) {
        sAppInstance.configureInstanceInternal(cameraXConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureInstanceInternal(@NonNull CameraXConfig cameraXConfig) {
        Object object = this.mLock;
        synchronized (object) {
            Preconditions.checkNotNull((Object)cameraXConfig);
            Preconditions.checkState((this.mCameraXConfigProvider == null ? 1 : 0) != 0, (String)"CameraX has already been configured. To use a different configuration, shutdown() must be called.");
            this.mCameraXConfigProvider = () -> cameraXConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    @NonNull
    public ListenableFuture<Void> shutdown() {
        this.mLifecycleCameraRepository.clear();
        ListenableFuture shutdownFuture = this.mCameraX != null ? this.mCameraX.shutdown() : Futures.immediateFuture(null);
        Object object = this.mLock;
        synchronized (object) {
            this.mCameraXConfigProvider = null;
            this.mCameraXInitializeFuture = null;
            this.mCameraXShutdownFuture = shutdownFuture;
        }
        this.mCameraX = null;
        this.mContext = null;
        return shutdownFuture;
    }

    private void setCameraX(CameraX cameraX) {
        this.mCameraX = cameraX;
    }

    private void setContext(Context context) {
        this.mContext = context;
    }

    @MainThread
    @NonNull
    public Camera bindToLifecycle(@NonNull LifecycleOwner lifecycleOwner, @NonNull CameraSelector cameraSelector, UseCase ... useCases) {
        return this.bindToLifecycle(lifecycleOwner, cameraSelector, null, Collections.emptyList(), useCases);
    }

    @MainThread
    @NonNull
    public Camera bindToLifecycle(@NonNull LifecycleOwner lifecycleOwner, @NonNull CameraSelector cameraSelector, @NonNull UseCaseGroup useCaseGroup) {
        return this.bindToLifecycle(lifecycleOwner, cameraSelector, useCaseGroup.getViewPort(), useCaseGroup.getEffects(), useCaseGroup.getUseCases().toArray(new UseCase[0]));
    }

    @NonNull
    Camera bindToLifecycle(@NonNull LifecycleOwner lifecycleOwner, @NonNull CameraSelector cameraSelector, @Nullable ViewPort viewPort, @NonNull List<CameraEffect> effects, UseCase ... useCases) {
        Threads.checkMainThread();
        CameraSelector.Builder selectorBuilder = CameraSelector.Builder.fromSelector((CameraSelector)cameraSelector);
        for (UseCase useCase : useCases) {
            CameraSelector selector = useCase.getCurrentConfig().getCameraSelector(null);
            if (selector == null) continue;
            for (CameraFilter filter : selector.getCameraFilterSet()) {
                selectorBuilder.addCameraFilter(filter);
            }
        }
        CameraSelector modifiedSelector = selectorBuilder.build();
        LinkedHashSet cameraInternals = modifiedSelector.filter(this.mCameraX.getCameraRepository().getCameras());
        if (cameraInternals.isEmpty()) {
            throw new IllegalArgumentException("Provided camera selector unable to resolve a camera for the given use case");
        }
        CameraUseCaseAdapter.CameraId cameraId = CameraUseCaseAdapter.generateCameraId((LinkedHashSet)cameraInternals);
        LifecycleCamera lifecycleCameraToBind = this.mLifecycleCameraRepository.getLifecycleCamera(lifecycleOwner, cameraId);
        Collection<LifecycleCamera> lifecycleCameras = this.mLifecycleCameraRepository.getLifecycleCameras();
        for (UseCase useCase : useCases) {
            for (LifecycleCamera lifecycleCamera : lifecycleCameras) {
                if (!lifecycleCamera.isBound(useCase) || lifecycleCamera == lifecycleCameraToBind) continue;
                throw new IllegalStateException(String.format("Use case %s already bound to a different lifecycle.", useCase));
            }
        }
        if (lifecycleCameraToBind == null) {
            lifecycleCameraToBind = this.mLifecycleCameraRepository.createLifecycleCamera(lifecycleOwner, new CameraUseCaseAdapter(cameraInternals, this.mCameraX.getCameraDeviceSurfaceManager(), this.mCameraX.getDefaultConfigFactory()));
        }
        CameraConfig cameraConfig = null;
        for (CameraFilter cameraFilter : cameraSelector.getCameraFilterSet()) {
            CameraConfig extendedCameraConfig;
            if (cameraFilter.getIdentifier() == CameraFilter.DEFAULT_ID || (extendedCameraConfig = ExtendedCameraConfigProviderStore.getConfigProvider((Object)cameraFilter.getIdentifier()).getConfig(lifecycleCameraToBind.getCameraInfo(), this.mContext)) == null) continue;
            if (cameraConfig != null) {
                throw new IllegalArgumentException("Cannot apply multiple extended camera configs at the same time.");
            }
            cameraConfig = extendedCameraConfig;
        }
        lifecycleCameraToBind.setExtendedConfig(cameraConfig);
        if (useCases.length == 0) {
            return lifecycleCameraToBind;
        }
        this.mLifecycleCameraRepository.bindToLifecycleCamera(lifecycleCameraToBind, viewPort, effects, Arrays.asList(useCases));
        return lifecycleCameraToBind;
    }

    @Override
    public boolean isBound(@NonNull UseCase useCase) {
        for (LifecycleCamera lifecycleCamera : this.mLifecycleCameraRepository.getLifecycleCameras()) {
            if (!lifecycleCamera.isBound(useCase)) continue;
            return true;
        }
        return false;
    }

    @Override
    @MainThread
    public void unbind(UseCase ... useCases) {
        Threads.checkMainThread();
        this.mLifecycleCameraRepository.unbind(Arrays.asList(useCases));
    }

    @Override
    @MainThread
    public void unbindAll() {
        Threads.checkMainThread();
        this.mLifecycleCameraRepository.unbindAll();
    }

    public boolean hasCamera(@NonNull CameraSelector cameraSelector) throws CameraInfoUnavailableException {
        try {
            cameraSelector.select(this.mCameraX.getCameraRepository().getCameras());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @NonNull
    public List<CameraInfo> getAvailableCameraInfos() {
        ArrayList<CameraInfo> availableCameraInfos = new ArrayList<CameraInfo>();
        LinkedHashSet cameras = this.mCameraX.getCameraRepository().getCameras();
        for (CameraInternal camera : cameras) {
            availableCameraInfos.add(camera.getCameraInfo());
        }
        return availableCameraInfos;
    }

    private ProcessCameraProvider() {
    }
}

