/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.util.Range;
import androidx.annotation.NonNull;
import androidx.camera.video.QualitySelector;
import androidx.camera.video.VideoSpec;

final class AutoValue_VideoSpec
extends VideoSpec {
    private final QualitySelector qualitySelector;
    private final Range<Integer> frameRate;
    private final Range<Integer> bitrate;
    private final int aspectRatio;

    private AutoValue_VideoSpec(QualitySelector qualitySelector, Range<Integer> frameRate, Range<Integer> bitrate, int aspectRatio) {
        this.qualitySelector = qualitySelector;
        this.frameRate = frameRate;
        this.bitrate = bitrate;
        this.aspectRatio = aspectRatio;
    }

    @Override
    @NonNull
    public QualitySelector getQualitySelector() {
        return this.qualitySelector;
    }

    @Override
    @NonNull
    public Range<Integer> getFrameRate() {
        return this.frameRate;
    }

    @Override
    @NonNull
    public Range<Integer> getBitrate() {
        return this.bitrate;
    }

    @Override
    int getAspectRatio() {
        return this.aspectRatio;
    }

    public String toString() {
        return "VideoSpec{qualitySelector=" + this.qualitySelector + ", frameRate=" + this.frameRate + ", bitrate=" + this.bitrate + ", aspectRatio=" + this.aspectRatio + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof VideoSpec) {
            VideoSpec that = (VideoSpec)o;
            return this.qualitySelector.equals(that.getQualitySelector()) && this.frameRate.equals(that.getFrameRate()) && this.bitrate.equals(that.getBitrate()) && this.aspectRatio == that.getAspectRatio();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.qualitySelector.hashCode();
        h$ *= 1000003;
        h$ ^= this.frameRate.hashCode();
        h$ *= 1000003;
        h$ ^= this.bitrate.hashCode();
        h$ *= 1000003;
        return h$ ^= this.aspectRatio;
    }

    @Override
    public VideoSpec.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends VideoSpec.Builder {
        private QualitySelector qualitySelector;
        private Range<Integer> frameRate;
        private Range<Integer> bitrate;
        private Integer aspectRatio;

        Builder() {
        }

        private Builder(VideoSpec source) {
            this.qualitySelector = source.getQualitySelector();
            this.frameRate = source.getFrameRate();
            this.bitrate = source.getBitrate();
            this.aspectRatio = source.getAspectRatio();
        }

        @Override
        public VideoSpec.Builder setQualitySelector(QualitySelector qualitySelector) {
            if (qualitySelector == null) {
                throw new NullPointerException("Null qualitySelector");
            }
            this.qualitySelector = qualitySelector;
            return this;
        }

        @Override
        public VideoSpec.Builder setFrameRate(Range<Integer> frameRate) {
            if (frameRate == null) {
                throw new NullPointerException("Null frameRate");
            }
            this.frameRate = frameRate;
            return this;
        }

        @Override
        public VideoSpec.Builder setBitrate(Range<Integer> bitrate) {
            if (bitrate == null) {
                throw new NullPointerException("Null bitrate");
            }
            this.bitrate = bitrate;
            return this;
        }

        @Override
        VideoSpec.Builder setAspectRatio(int aspectRatio) {
            this.aspectRatio = aspectRatio;
            return this;
        }

        @Override
        public VideoSpec build() {
            String missing = "";
            if (this.qualitySelector == null) {
                missing = missing + " qualitySelector";
            }
            if (this.frameRate == null) {
                missing = missing + " frameRate";
            }
            if (this.bitrate == null) {
                missing = missing + " bitrate";
            }
            if (this.aspectRatio == null) {
                missing = missing + " aspectRatio";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_VideoSpec(this.qualitySelector, this.frameRate, this.bitrate, this.aspectRatio);
        }
    }
}

