/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.arch.core.util.Function;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.ResolutionValidatedEncoderProfilesProvider;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.camera.video.Quality;
import androidx.camera.video.VideoCapabilities;
import androidx.camera.video.internal.BackupHdrProfileEncoderProfilesProvider;
import androidx.camera.video.internal.DynamicRangeMatchedEncoderProfilesProvider;
import androidx.camera.video.internal.VideoValidatedEncoderProfilesProxy;
import androidx.camera.video.internal.compat.quirk.DeviceQuirks;
import androidx.camera.video.internal.workaround.QualityValidatedEncoderProfilesProvider;
import androidx.core.util.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@RequiresApi(value=21)
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class RecorderVideoCapabilities
implements VideoCapabilities {
    private static final String TAG = "RecorderVideoCapabilities";
    private final EncoderProfilesProvider mProfilesProvider;
    private final Map<DynamicRange, CapabilitiesByQuality> mCapabilitiesMapForFullySpecifiedDynamicRange = new HashMap<DynamicRange, CapabilitiesByQuality>();
    private final Map<DynamicRange, CapabilitiesByQuality> mCapabilitiesMapForNonFullySpecifiedDynamicRange = new HashMap<DynamicRange, CapabilitiesByQuality>();

    @VisibleForTesting
    RecorderVideoCapabilities(@NonNull CameraInfoInternal cameraInfoInternal, @NonNull Function<EncoderProfilesProxy.VideoProfileProxy, EncoderProfilesProxy.VideoProfileProxy> backupVideoProfileValidator) {
        EncoderProfilesProvider encoderProfilesProvider = cameraInfoInternal.getEncoderProfilesProvider();
        if (RecorderVideoCapabilities.isHlg10SupportedByCamera(cameraInfoInternal)) {
            encoderProfilesProvider = new BackupHdrProfileEncoderProfilesProvider(encoderProfilesProvider, backupVideoProfileValidator);
        }
        Quirks cameraQuirks = cameraInfoInternal.getCameraQuirks();
        encoderProfilesProvider = new ResolutionValidatedEncoderProfilesProvider(encoderProfilesProvider, cameraQuirks);
        Quirks deviceQuirks = DeviceQuirks.getAll();
        this.mProfilesProvider = encoderProfilesProvider = new QualityValidatedEncoderProfilesProvider(encoderProfilesProvider, cameraInfoInternal, deviceQuirks);
        for (DynamicRange dynamicRange : cameraInfoInternal.getSupportedDynamicRanges()) {
            DynamicRangeMatchedEncoderProfilesProvider constrainedProvider = new DynamicRangeMatchedEncoderProfilesProvider(this.mProfilesProvider, dynamicRange);
            CapabilitiesByQuality capabilities = new CapabilitiesByQuality(constrainedProvider);
            if (capabilities.getSupportedQualities().isEmpty()) continue;
            this.mCapabilitiesMapForFullySpecifiedDynamicRange.put(dynamicRange, capabilities);
        }
    }

    @NonNull
    static RecorderVideoCapabilities from(@NonNull CameraInfo cameraInfo) {
        return new RecorderVideoCapabilities((CameraInfoInternal)cameraInfo, BackupHdrProfileEncoderProfilesProvider.DEFAULT_VALIDATOR);
    }

    @Override
    @NonNull
    public Set<DynamicRange> getSupportedDynamicRanges() {
        return this.mCapabilitiesMapForFullySpecifiedDynamicRange.keySet();
    }

    @Override
    @NonNull
    public List<Quality> getSupportedQualities(@NonNull DynamicRange dynamicRange) {
        CapabilitiesByQuality capabilities = this.getCapabilities(dynamicRange);
        return capabilities == null ? new ArrayList() : capabilities.getSupportedQualities();
    }

    @Override
    public boolean isQualitySupported(@NonNull Quality quality, @NonNull DynamicRange dynamicRange) {
        CapabilitiesByQuality capabilities = this.getCapabilities(dynamicRange);
        return capabilities != null && capabilities.isQualitySupported(quality);
    }

    @Override
    @Nullable
    public VideoValidatedEncoderProfilesProxy getProfiles(@NonNull Quality quality, @NonNull DynamicRange dynamicRange) {
        CapabilitiesByQuality capabilities = this.getCapabilities(dynamicRange);
        return capabilities == null ? null : capabilities.getProfiles(quality);
    }

    @Override
    @Nullable
    public VideoValidatedEncoderProfilesProxy findHighestSupportedEncoderProfilesFor(@NonNull Size size, @NonNull DynamicRange dynamicRange) {
        CapabilitiesByQuality capabilities = this.getCapabilities(dynamicRange);
        return capabilities == null ? null : capabilities.findHighestSupportedEncoderProfilesFor(size);
    }

    @Override
    @NonNull
    public Quality findHighestSupportedQualityFor(@NonNull Size size, @NonNull DynamicRange dynamicRange) {
        CapabilitiesByQuality capabilities = this.getCapabilities(dynamicRange);
        return capabilities == null ? Quality.NONE : capabilities.findHighestSupportedQualityFor(size);
    }

    @Nullable
    private CapabilitiesByQuality getCapabilities(@NonNull DynamicRange dynamicRange) {
        if (RecorderVideoCapabilities.isFullySpecified(dynamicRange)) {
            return this.mCapabilitiesMapForFullySpecifiedDynamicRange.get(dynamicRange);
        }
        if (this.mCapabilitiesMapForNonFullySpecifiedDynamicRange.containsKey(dynamicRange)) {
            return this.mCapabilitiesMapForNonFullySpecifiedDynamicRange.get(dynamicRange);
        }
        CapabilitiesByQuality capabilities = this.generateCapabilitiesForNonFullySpecifiedDynamicRange(dynamicRange);
        this.mCapabilitiesMapForNonFullySpecifiedDynamicRange.put(dynamicRange, capabilities);
        return capabilities;
    }

    private static boolean isHlg10SupportedByCamera(@NonNull CameraInfoInternal cameraInfoInternal) {
        Set dynamicRanges = cameraInfoInternal.getSupportedDynamicRanges();
        for (DynamicRange dynamicRange : dynamicRanges) {
            Integer encoding = dynamicRange.getEncoding();
            int bitDepth = dynamicRange.getBitDepth();
            if (!encoding.equals(3) || bitDepth != 10) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private CapabilitiesByQuality generateCapabilitiesForNonFullySpecifiedDynamicRange(@NonNull DynamicRange dynamicRange) {
        if (!RecorderVideoCapabilities.canResolve(dynamicRange, this.getSupportedDynamicRanges())) {
            return null;
        }
        DynamicRangeMatchedEncoderProfilesProvider constrainedProvider = new DynamicRangeMatchedEncoderProfilesProvider(this.mProfilesProvider, dynamicRange);
        return new CapabilitiesByQuality(constrainedProvider);
    }

    private static boolean canResolve(@NonNull DynamicRange dynamicRangeToTest, @NonNull Set<DynamicRange> fullySpecifiedDynamicRanges) {
        if (RecorderVideoCapabilities.isFullySpecified(dynamicRangeToTest)) {
            return fullySpecifiedDynamicRanges.contains(dynamicRangeToTest);
        }
        for (DynamicRange fullySpecifiedDynamicRange : fullySpecifiedDynamicRanges) {
            if (!RecorderVideoCapabilities.canMatchBitDepth(dynamicRangeToTest, fullySpecifiedDynamicRange) || !RecorderVideoCapabilities.canMatchEncoding(dynamicRangeToTest, fullySpecifiedDynamicRange)) continue;
            return true;
        }
        return false;
    }

    private static boolean canMatchBitDepth(@NonNull DynamicRange dynamicRangeToTest, @NonNull DynamicRange fullySpecifiedDynamicRange) {
        Preconditions.checkState((boolean)RecorderVideoCapabilities.isFullySpecified(fullySpecifiedDynamicRange), (String)"Fully specified range is not actually fully specified.");
        if (dynamicRangeToTest.getBitDepth() == 0) {
            return true;
        }
        return dynamicRangeToTest.getBitDepth() == fullySpecifiedDynamicRange.getBitDepth();
    }

    private static boolean canMatchEncoding(@NonNull DynamicRange dynamicRangeToTest, @NonNull DynamicRange fullySpecifiedDynamicRange) {
        Preconditions.checkState((boolean)RecorderVideoCapabilities.isFullySpecified(fullySpecifiedDynamicRange), (String)"Fully specified range is not actually fully specified.");
        int encodingToTest = dynamicRangeToTest.getEncoding();
        if (encodingToTest == 0) {
            return true;
        }
        int fullySpecifiedEncoding = fullySpecifiedDynamicRange.getEncoding();
        if (encodingToTest == 2 && fullySpecifiedEncoding != 1) {
            return true;
        }
        return encodingToTest == fullySpecifiedEncoding;
    }

    private static boolean isFullySpecified(@NonNull DynamicRange dynamicRange) {
        return dynamicRange.getEncoding() != 0 && dynamicRange.getEncoding() != 2 && dynamicRange.getBitDepth() != 0;
    }

    @VisibleForTesting
    static class CapabilitiesByQuality {
        private final Map<Quality, VideoValidatedEncoderProfilesProxy> mSupportedProfilesMap = new LinkedHashMap<Quality, VideoValidatedEncoderProfilesProxy>();
        private final TreeMap<Size, Quality> mAreaSortedSizeToQualityMap = new TreeMap(new CompareSizesByArea());
        private final VideoValidatedEncoderProfilesProxy mHighestProfiles;
        private final VideoValidatedEncoderProfilesProxy mLowestProfiles;

        CapabilitiesByQuality(@NonNull EncoderProfilesProvider provider) {
            for (Quality quality : Quality.getSortedQualities()) {
                EncoderProfilesProxy profiles = this.getEncoderProfiles(quality, provider);
                if (profiles == null) continue;
                Logger.d((String)RecorderVideoCapabilities.TAG, (String)("profiles = " + profiles));
                VideoValidatedEncoderProfilesProxy validatedProfiles = this.toValidatedProfiles(profiles);
                if (validatedProfiles == null) {
                    Logger.w((String)RecorderVideoCapabilities.TAG, (String)("EncoderProfiles of quality " + quality + " has no video validated profiles."));
                    continue;
                }
                EncoderProfilesProxy.VideoProfileProxy videoProfile = validatedProfiles.getDefaultVideoProfile();
                Size size = new Size(videoProfile.getWidth(), videoProfile.getHeight());
                this.mAreaSortedSizeToQualityMap.put(size, quality);
                this.mSupportedProfilesMap.put(quality, validatedProfiles);
            }
            if (this.mSupportedProfilesMap.isEmpty()) {
                Logger.e((String)RecorderVideoCapabilities.TAG, (String)"No supported EncoderProfiles");
                this.mLowestProfiles = null;
                this.mHighestProfiles = null;
            } else {
                ArrayDeque<VideoValidatedEncoderProfilesProxy> profileQueue = new ArrayDeque<VideoValidatedEncoderProfilesProxy>(this.mSupportedProfilesMap.values());
                this.mHighestProfiles = (VideoValidatedEncoderProfilesProxy)profileQueue.peekFirst();
                this.mLowestProfiles = (VideoValidatedEncoderProfilesProxy)profileQueue.peekLast();
            }
        }

        @NonNull
        public List<Quality> getSupportedQualities() {
            return new ArrayList<Quality>(this.mSupportedProfilesMap.keySet());
        }

        public boolean isQualitySupported(@NonNull Quality quality) {
            CapabilitiesByQuality.checkQualityConstantsOrThrow(quality);
            return this.getProfiles(quality) != null;
        }

        @Nullable
        public VideoValidatedEncoderProfilesProxy getProfiles(@NonNull Quality quality) {
            CapabilitiesByQuality.checkQualityConstantsOrThrow(quality);
            if (quality == Quality.HIGHEST) {
                return this.mHighestProfiles;
            }
            if (quality == Quality.LOWEST) {
                return this.mLowestProfiles;
            }
            return this.mSupportedProfilesMap.get(quality);
        }

        @Nullable
        public VideoValidatedEncoderProfilesProxy findHighestSupportedEncoderProfilesFor(@NonNull Size size) {
            VideoValidatedEncoderProfilesProxy encoderProfiles = null;
            Quality highestSupportedQuality = this.findHighestSupportedQualityFor(size);
            Logger.d((String)RecorderVideoCapabilities.TAG, (String)("Using supported quality of " + highestSupportedQuality + " for size " + size));
            if (highestSupportedQuality != Quality.NONE && (encoderProfiles = this.getProfiles(highestSupportedQuality)) == null) {
                throw new AssertionError((Object)"Camera advertised available quality but did not produce EncoderProfiles for advertised quality.");
            }
            return encoderProfiles;
        }

        @NonNull
        public Quality findHighestSupportedQualityFor(@NonNull Size size) {
            Map.Entry<Size, Quality> ceilEntry = this.mAreaSortedSizeToQualityMap.ceilingEntry(size);
            if (ceilEntry != null) {
                return ceilEntry.getValue();
            }
            Map.Entry<Size, Quality> floorEntry = this.mAreaSortedSizeToQualityMap.floorEntry(size);
            if (floorEntry != null) {
                return floorEntry.getValue();
            }
            return Quality.NONE;
        }

        @Nullable
        private EncoderProfilesProxy getEncoderProfiles(@NonNull Quality quality, @NonNull EncoderProfilesProvider provider) {
            Preconditions.checkState((boolean)(quality instanceof Quality.ConstantQuality), (String)"Currently only support ConstantQuality");
            int qualityValue = ((Quality.ConstantQuality)quality).getValue();
            return provider.getAll(qualityValue);
        }

        @Nullable
        private VideoValidatedEncoderProfilesProxy toValidatedProfiles(@NonNull EncoderProfilesProxy profiles) {
            List videoProfiles = profiles.getVideoProfiles();
            if (videoProfiles.isEmpty()) {
                return null;
            }
            return VideoValidatedEncoderProfilesProxy.from(profiles);
        }

        private static void checkQualityConstantsOrThrow(@NonNull Quality quality) {
            Preconditions.checkArgument((boolean)Quality.containsQuality(quality), (Object)("Unknown quality: " + quality));
        }
    }
}

