/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.encoder;

import android.media.MediaFormat;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.Timebase;
import androidx.camera.video.internal.encoder.AutoValue_VideoEncoderConfig;
import androidx.camera.video.internal.encoder.EncoderConfig;
import androidx.camera.video.internal.encoder.VideoEncoderDataSpace;
import com.google.auto.value.AutoValue;

@RequiresApi(value=21)
@AutoValue
public abstract class VideoEncoderConfig
implements EncoderConfig {
    private static final int VIDEO_INTRA_FRAME_INTERVAL_DEFAULT = 1;
    private static final int VIDEO_COLOR_FORMAT_DEFAULT = 2130708361;

    VideoEncoderConfig() {
    }

    @NonNull
    public static Builder builder() {
        return new AutoValue_VideoEncoderConfig.Builder().setProfile(-1).setIFrameInterval(1).setColorFormat(2130708361).setDataSpace(VideoEncoderDataSpace.ENCODER_DATA_SPACE_UNSPECIFIED);
    }

    @Override
    @NonNull
    public abstract String getMimeType();

    @Override
    public abstract int getProfile();

    @Override
    @NonNull
    public abstract Timebase getInputTimebase();

    @NonNull
    public abstract Size getResolution();

    public abstract int getColorFormat();

    @NonNull
    public abstract VideoEncoderDataSpace getDataSpace();

    public abstract int getFrameRate();

    public abstract int getIFrameInterval();

    public abstract int getBitrate();

    @Override
    @NonNull
    public MediaFormat toMediaFormat() {
        VideoEncoderDataSpace dataSpace;
        Size size = this.getResolution();
        MediaFormat format = MediaFormat.createVideoFormat((String)this.getMimeType(), (int)size.getWidth(), (int)size.getHeight());
        format.setInteger("color-format", this.getColorFormat());
        format.setInteger("bitrate", this.getBitrate());
        format.setInteger("frame-rate", this.getFrameRate());
        format.setInteger("i-frame-interval", this.getIFrameInterval());
        if (this.getProfile() != -1) {
            format.setInteger("profile", this.getProfile());
        }
        if ((dataSpace = this.getDataSpace()).getStandard() != 0) {
            format.setInteger("color-standard", dataSpace.getStandard());
        }
        if (dataSpace.getTransfer() != 0) {
            format.setInteger("color-transfer", dataSpace.getTransfer());
        }
        if (dataSpace.getRange() != 0) {
            format.setInteger("color-range", dataSpace.getRange());
        }
        return format;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        @NonNull
        public abstract Builder setMimeType(@NonNull String var1);

        @NonNull
        public abstract Builder setProfile(int var1);

        @NonNull
        public abstract Builder setInputTimebase(@NonNull Timebase var1);

        @NonNull
        public abstract Builder setResolution(@NonNull Size var1);

        @NonNull
        public abstract Builder setColorFormat(int var1);

        @NonNull
        public abstract Builder setDataSpace(@NonNull VideoEncoderDataSpace var1);

        @NonNull
        public abstract Builder setFrameRate(int var1);

        @NonNull
        public abstract Builder setIFrameInterval(int var1);

        @NonNull
        public abstract Builder setBitrate(int var1);

        @NonNull
        public abstract VideoEncoderConfig build();
    }
}

