/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.content.Context;
import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.camera.core.impl.utils.ContextUtil;
import androidx.camera.video.ExperimentalPersistentRecording;
import androidx.camera.video.OutputOptions;
import androidx.camera.video.Recorder;
import androidx.camera.video.Recording;
import androidx.camera.video.VideoRecordEvent;
import androidx.core.content.PermissionChecker;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public final class PendingRecording {
    private final Context mContext;
    private final Recorder mRecorder;
    private final OutputOptions mOutputOptions;
    private Consumer<VideoRecordEvent> mEventListener;
    private Executor mListenerExecutor;
    private boolean mAudioEnabled = false;
    private boolean mIsPersistent = false;

    PendingRecording(@NonNull Context context, @NonNull Recorder recorder, @NonNull OutputOptions options) {
        this.mContext = ContextUtil.getApplicationContext((Context)context);
        this.mRecorder = recorder;
        this.mOutputOptions = options;
    }

    @NonNull
    Context getApplicationContext() {
        return this.mContext;
    }

    @NonNull
    Recorder getRecorder() {
        return this.mRecorder;
    }

    @NonNull
    OutputOptions getOutputOptions() {
        return this.mOutputOptions;
    }

    @Nullable
    Executor getListenerExecutor() {
        return this.mListenerExecutor;
    }

    @Nullable
    Consumer<VideoRecordEvent> getEventListener() {
        return this.mEventListener;
    }

    boolean isAudioEnabled() {
        return this.mAudioEnabled;
    }

    boolean isPersistent() {
        return this.mIsPersistent;
    }

    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    @NonNull
    public PendingRecording withAudioEnabled() {
        if (PermissionChecker.checkSelfPermission((Context)this.mContext, (String)"android.permission.RECORD_AUDIO") == -1) {
            throw new SecurityException("Attempted to enable audio for recording but application does not have RECORD_AUDIO permission granted.");
        }
        Preconditions.checkState((boolean)this.mRecorder.isAudioSupported(), (String)"The Recorder this recording is associated to doesn't support audio.");
        this.mAudioEnabled = true;
        return this;
    }

    @ExperimentalPersistentRecording
    @NonNull
    public PendingRecording asPersistentRecording() {
        this.mIsPersistent = true;
        return this;
    }

    @NonNull
    @CheckResult
    public Recording start(@NonNull Executor listenerExecutor, @NonNull Consumer<VideoRecordEvent> listener) {
        Preconditions.checkNotNull((Object)listenerExecutor, (Object)"Listener Executor can't be null.");
        Preconditions.checkNotNull(listener, (Object)"Event listener can't be null");
        this.mListenerExecutor = listenerExecutor;
        this.mEventListener = listener;
        return this.mRecorder.start(this);
    }
}

