/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.video.FallbackStrategy;
import androidx.camera.video.Quality;
import androidx.camera.video.Recorder;
import androidx.camera.video.VideoCapabilities;
import androidx.camera.video.internal.VideoValidatedEncoderProfilesProxy;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@RequiresApi(value=21)
public final class QualitySelector {
    private static final String TAG = "QualitySelector";
    private final List<Quality> mPreferredQualityList;
    private final FallbackStrategy mFallbackStrategy;

    @Deprecated
    @NonNull
    public static List<Quality> getSupportedQualities(@NonNull CameraInfo cameraInfo) {
        return Recorder.getVideoCapabilities(cameraInfo).getSupportedQualities(DynamicRange.SDR);
    }

    @Deprecated
    public static boolean isQualitySupported(@NonNull CameraInfo cameraInfo, @NonNull Quality quality) {
        return Recorder.getVideoCapabilities(cameraInfo).isQualitySupported(quality, DynamicRange.SDR);
    }

    @Nullable
    public static Size getResolution(@NonNull CameraInfo cameraInfo, @NonNull Quality quality) {
        QualitySelector.checkQualityConstantsOrThrow(quality);
        VideoCapabilities videoCapabilities = Recorder.getVideoCapabilities(cameraInfo);
        VideoValidatedEncoderProfilesProxy profiles = videoCapabilities.getProfiles(quality, DynamicRange.SDR);
        return profiles != null ? QualitySelector.getProfileVideoSize(profiles) : null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public static Map<Quality, Size> getQualityToResolutionMap(@NonNull VideoCapabilities videoCapabilities, @NonNull DynamicRange dynamicRange) {
        HashMap<Quality, Size> map = new HashMap<Quality, Size>();
        for (Quality supportedQuality : videoCapabilities.getSupportedQualities(dynamicRange)) {
            map.put(supportedQuality, QualitySelector.getProfileVideoSize(Objects.requireNonNull(videoCapabilities.getProfiles(supportedQuality, dynamicRange))));
        }
        return map;
    }

    QualitySelector(@NonNull List<Quality> preferredQualityList, @NonNull FallbackStrategy fallbackStrategy) {
        Preconditions.checkArgument((!preferredQualityList.isEmpty() || fallbackStrategy != FallbackStrategy.NONE ? 1 : 0) != 0, (Object)"No preferred quality and fallback strategy.");
        this.mPreferredQualityList = Collections.unmodifiableList(new ArrayList<Quality>(preferredQualityList));
        this.mFallbackStrategy = fallbackStrategy;
    }

    @NonNull
    public static QualitySelector from(@NonNull Quality quality) {
        return QualitySelector.from(quality, FallbackStrategy.NONE);
    }

    @NonNull
    public static QualitySelector from(@NonNull Quality quality, @NonNull FallbackStrategy fallbackStrategy) {
        Preconditions.checkNotNull((Object)quality, (Object)"quality cannot be null");
        Preconditions.checkNotNull((Object)fallbackStrategy, (Object)"fallbackStrategy cannot be null");
        QualitySelector.checkQualityConstantsOrThrow(quality);
        return new QualitySelector(Collections.singletonList(quality), fallbackStrategy);
    }

    @NonNull
    public static QualitySelector fromOrderedList(@NonNull List<Quality> qualities) {
        return QualitySelector.fromOrderedList(qualities, FallbackStrategy.NONE);
    }

    @NonNull
    public static QualitySelector fromOrderedList(@NonNull List<Quality> qualities, @NonNull FallbackStrategy fallbackStrategy) {
        Preconditions.checkNotNull(qualities, (Object)"qualities cannot be null");
        Preconditions.checkNotNull((Object)fallbackStrategy, (Object)"fallbackStrategy cannot be null");
        Preconditions.checkArgument((!qualities.isEmpty() ? 1 : 0) != 0, (Object)"qualities cannot be empty");
        QualitySelector.checkQualityConstantsOrThrow(qualities);
        return new QualitySelector(qualities, fallbackStrategy);
    }

    @NonNull
    List<Quality> getPrioritizedQualities(@NonNull List<Quality> supportedQualities) {
        if (supportedQualities.isEmpty()) {
            Logger.w((String)TAG, (String)"No supported quality on the device.");
            return new ArrayList<Quality>();
        }
        Logger.d((String)TAG, (String)("supportedQualities = " + supportedQualities));
        LinkedHashSet<Quality> sortedQualities = new LinkedHashSet<Quality>();
        for (Quality quality : this.mPreferredQualityList) {
            if (quality == Quality.HIGHEST) {
                sortedQualities.addAll(supportedQualities);
                break;
            }
            if (quality == Quality.LOWEST) {
                ArrayList<Quality> reversedList = new ArrayList<Quality>(supportedQualities);
                Collections.reverse(reversedList);
                sortedQualities.addAll(reversedList);
                break;
            }
            if (supportedQualities.contains(quality)) {
                sortedQualities.add(quality);
                continue;
            }
            Logger.w((String)TAG, (String)("quality is not supported and will be ignored: " + quality));
        }
        this.addByFallbackStrategy(supportedQualities, sortedQualities);
        return new ArrayList<Quality>(sortedQualities);
    }

    @NonNull
    public String toString() {
        return "QualitySelector{preferredQualities=" + this.mPreferredQualityList + ", fallbackStrategy=" + this.mFallbackStrategy + "}";
    }

    private void addByFallbackStrategy(@NonNull List<Quality> supportedQualities, @NonNull Set<Quality> priorityQualities) {
        if (supportedQualities.isEmpty()) {
            return;
        }
        if (priorityQualities.containsAll(supportedQualities)) {
            return;
        }
        Logger.d((String)TAG, (String)("Select quality by fallbackStrategy = " + this.mFallbackStrategy));
        if (this.mFallbackStrategy == FallbackStrategy.NONE) {
            return;
        }
        Preconditions.checkState((boolean)(this.mFallbackStrategy instanceof FallbackStrategy.RuleStrategy), (String)"Currently only support type RuleStrategy");
        FallbackStrategy.RuleStrategy fallbackStrategy = (FallbackStrategy.RuleStrategy)this.mFallbackStrategy;
        List<Quality> sizeSortedQualities = Quality.getSortedQualities();
        Quality fallbackQuality = fallbackStrategy.getFallbackQuality() == Quality.HIGHEST ? sizeSortedQualities.get(0) : (fallbackStrategy.getFallbackQuality() == Quality.LOWEST ? sizeSortedQualities.get(sizeSortedQualities.size() - 1) : fallbackStrategy.getFallbackQuality());
        int index = sizeSortedQualities.indexOf(fallbackQuality);
        Preconditions.checkState((index != -1 ? 1 : 0) != 0);
        ArrayList<Quality> largerQualities = new ArrayList<Quality>();
        for (int i = index - 1; i >= 0; --i) {
            Quality quality = sizeSortedQualities.get(i);
            if (!supportedQualities.contains(quality)) continue;
            largerQualities.add(quality);
        }
        ArrayList<Quality> smallerQualities = new ArrayList<Quality>();
        for (int i = index + 1; i < sizeSortedQualities.size(); ++i) {
            Quality quality = sizeSortedQualities.get(i);
            if (!supportedQualities.contains(quality)) continue;
            smallerQualities.add(quality);
        }
        Logger.d((String)TAG, (String)("sizeSortedQualities = " + sizeSortedQualities + ", fallback quality = " + fallbackQuality + ", largerQualities = " + largerQualities + ", smallerQualities = " + smallerQualities));
        switch (fallbackStrategy.getFallbackRule()) {
            case 1: {
                priorityQualities.addAll(largerQualities);
                priorityQualities.addAll(smallerQualities);
                break;
            }
            case 2: {
                priorityQualities.addAll(largerQualities);
                break;
            }
            case 3: {
                priorityQualities.addAll(smallerQualities);
                priorityQualities.addAll(largerQualities);
                break;
            }
            case 4: {
                priorityQualities.addAll(smallerQualities);
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled fallback strategy: " + this.mFallbackStrategy));
            }
        }
    }

    @NonNull
    private static Size getProfileVideoSize(@NonNull VideoValidatedEncoderProfilesProxy profiles) {
        EncoderProfilesProxy.VideoProfileProxy videoProfile = profiles.getDefaultVideoProfile();
        return new Size(videoProfile.getWidth(), videoProfile.getHeight());
    }

    private static void checkQualityConstantsOrThrow(@NonNull List<Quality> qualities) {
        for (Quality quality : qualities) {
            Preconditions.checkArgument((boolean)Quality.containsQuality(quality), (Object)("qualities contain invalid quality: " + quality));
        }
    }

    private static void checkQualityConstantsOrThrow(@NonNull Quality quality) {
        Preconditions.checkArgument((boolean)Quality.containsQuality(quality), (Object)("Invalid quality: " + quality));
    }
}

