/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.RestrictTo;
import androidx.annotation.experimental.UseExperimental;
import androidx.camera.core.Camera;
import androidx.camera.core.UseCaseGroup;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.lifecycle.ExperimentalUseCaseGroupLifecycle;
import androidx.camera.view.CameraController;
import androidx.lifecycle.LifecycleOwner;

public final class LifecycleCameraController
extends CameraController {
    private static final String TAG = "CamLifecycleController";
    @Nullable
    private LifecycleOwner mLifecycleOwner;

    public LifecycleCameraController(@NonNull Context context) {
        super(context);
    }

    @SuppressLint(value={"MissingPermission"})
    @MainThread
    public void bindToLifecycle(@NonNull LifecycleOwner lifecycleOwner) {
        Threads.checkMainThread();
        this.mLifecycleOwner = lifecycleOwner;
        this.startCameraAndTrackStates();
    }

    @MainThread
    public void unbind() {
        Threads.checkMainThread();
        this.mLifecycleOwner = null;
        this.mCamera = null;
        if (this.mCameraProvider != null) {
            this.mCameraProvider.unbindAll();
        }
    }

    @Override
    @UseExperimental(markerClass=ExperimentalUseCaseGroupLifecycle.class)
    @RequiresPermission(value="android.permission.CAMERA")
    @Nullable
    Camera startCamera() {
        if (this.mLifecycleOwner == null) {
            Log.d((String)TAG, (String)"Lifecycle is not set.");
            return null;
        }
        if (this.mCameraProvider == null) {
            Log.d((String)TAG, (String)"CameraProvider is not ready.");
            return null;
        }
        UseCaseGroup useCaseGroup = this.createUseCaseGroup();
        if (useCaseGroup == null) {
            return null;
        }
        return this.mCameraProvider.bindToLifecycle(this.mLifecycleOwner, this.mCameraSelector, useCaseGroup);
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    void shutDownForTests() {
        if (this.mCameraProvider != null) {
            this.mCameraProvider.unbindAll();
            this.mCameraProvider.shutdown();
        }
    }
}

