/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.content.Context;
import android.view.OrientationEventListener;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class SensorRotationListener
extends OrientationEventListener {
    public static final int INVALID_SURFACE_ROTATION = -1;
    private int mRotation = -1;

    public SensorRotationListener(@NonNull Context context) {
        super(context);
    }

    public void onOrientationChanged(int orientation) {
        if (orientation == -1) {
            return;
        }
        int newRotation = orientation >= 315 || orientation < 45 ? 0 : (orientation >= 225 ? 1 : (orientation >= 135 ? 2 : 3));
        if (this.mRotation != newRotation) {
            this.mRotation = newRotation;
            this.onRotationChanged(newRotation);
        }
    }

    public abstract void onRotationChanged(int var1);
}

