/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view.preview.transform;

import android.util.Pair;
import android.util.Size;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.camera.view.preview.transform.RotationTransform;
import androidx.camera.view.preview.transform.transformation.PreviewCorrectionTransformation;

final class PreviewCorrector {
    private PreviewCorrector() {
    }

    @NonNull
    static PreviewCorrectionTransformation getCorrectionTransformation(@NonNull View container, @NonNull View preview, @NonNull Size bufferSize, boolean sensorDimensionFlipNeeded, int deviceRotation) {
        int rotation = (int)RotationTransform.getRotationDegrees(preview, deviceRotation);
        Pair<Float, Float> scaleXY = PreviewCorrector.getCorrectionScale(container, preview, bufferSize, sensorDimensionFlipNeeded);
        return new PreviewCorrectionTransformation(((Float)scaleXY.first).floatValue(), ((Float)scaleXY.second).floatValue(), -rotation);
    }

    private static Pair<Float, Float> getCorrectionScale(@NonNull View container, @NonNull View preview, @NonNull Size bufferSize, boolean sensorDimensionFlipNeeded) {
        int bufferHeight;
        int bufferWidth;
        if (container.getWidth() == 0 || container.getHeight() == 0 || preview.getWidth() == 0 || preview.getHeight() == 0 || bufferSize.getWidth() == 0 || bufferSize.getHeight() == 0) {
            return new Pair((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
        }
        if (sensorDimensionFlipNeeded) {
            bufferWidth = bufferSize.getHeight();
            bufferHeight = bufferSize.getWidth();
        } else {
            bufferWidth = bufferSize.getWidth();
            bufferHeight = bufferSize.getHeight();
        }
        float scaleX = (float)bufferWidth / (float)preview.getWidth();
        float scaleY = (float)bufferHeight / (float)preview.getHeight();
        return new Pair((Object)Float.valueOf(scaleX), (Object)Float.valueOf(scaleY));
    }
}

