/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view.preview.transform;

import android.util.Size;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.view.PreviewView;
import androidx.camera.view.preview.transform.PreviewCorrector;
import androidx.camera.view.preview.transform.ScaleTypeTransform;
import androidx.camera.view.preview.transform.transformation.PreviewCorrectionTransformation;
import androidx.camera.view.preview.transform.transformation.Transformation;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class PreviewTransform {
    private static final PreviewView.ScaleType DEFAULT_SCALE_TYPE = PreviewView.ScaleType.FILL_CENTER;
    @NonNull
    private PreviewView.ScaleType mScaleType = DEFAULT_SCALE_TYPE;
    @Nullable
    private Transformation mCurrentTransformation;
    private boolean mSensorDimensionFlipNeeded = true;
    private int mDeviceRotation = -1;

    @NonNull
    public PreviewView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void setScaleType(@NonNull PreviewView.ScaleType scaleType) {
        this.mScaleType = scaleType;
    }

    @Nullable
    public Transformation getCurrentTransformation() {
        return this.mCurrentTransformation;
    }

    public boolean isSensorDimensionFlipNeeded() {
        return this.mSensorDimensionFlipNeeded;
    }

    public void setSensorDimensionFlipNeeded(boolean sensorDimensionFlipNeeded) {
        this.mSensorDimensionFlipNeeded = sensorDimensionFlipNeeded;
    }

    public int getDeviceRotation() {
        return this.mDeviceRotation;
    }

    public void setDeviceRotation(int deviceRotation) {
        this.mDeviceRotation = deviceRotation;
    }

    public void applyCurrentScaleType(@NonNull View container, @NonNull View view, @NonNull Size bufferSize) {
        this.resetPreview(view);
        this.correctPreview(container, view, bufferSize);
        this.applyScaleTypeInternal(container, view, this.mScaleType, this.mDeviceRotation);
    }

    private void resetPreview(@NonNull View view) {
        Transformation reset = new Transformation();
        this.applyTransformation(view, reset);
    }

    private void correctPreview(@NonNull View container, @NonNull View view, @NonNull Size bufferSize) {
        PreviewCorrectionTransformation correct = PreviewCorrector.getCorrectionTransformation(container, view, bufferSize, this.mSensorDimensionFlipNeeded, this.mDeviceRotation);
        this.applyTransformation(view, correct);
    }

    private void applyScaleTypeInternal(@NonNull View container, @NonNull View view, @NonNull PreviewView.ScaleType scaleType, int deviceRotation) {
        Transformation current = Transformation.getTransformation(view);
        Transformation transformation = ScaleTypeTransform.getTransformation(container, view, scaleType, deviceRotation);
        this.applyTransformation(view, current.add(transformation));
    }

    private void applyTransformation(@NonNull View view, @NonNull Transformation transformation) {
        view.setX(0.0f);
        view.setY(0.0f);
        view.setScaleX(transformation.getScaleX());
        view.setScaleY(transformation.getScaleY());
        view.setTranslationX(transformation.getTransX());
        view.setTranslationY(transformation.getTransY());
        view.setRotation(transformation.getRotation());
        this.mCurrentTransformation = transformation;
    }
}

