/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.util.Size;
import android.view.PixelCopy;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.UiThread;
import androidx.camera.core.Logger;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.view.PreviewTransformation;
import androidx.camera.view.PreviewView;
import androidx.camera.view.PreviewViewImplementation;
import androidx.core.content.ContextCompat;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
final class SurfaceViewImplementation
extends PreviewViewImplementation {
    private static final String TAG = "SurfaceViewImpl";
    SurfaceView mSurfaceView;
    final SurfaceRequestCallback mSurfaceRequestCallback = new SurfaceRequestCallback();
    @Nullable
    private PreviewViewImplementation.OnSurfaceNotInUseListener mOnSurfaceNotInUseListener;

    SurfaceViewImplementation(@NonNull FrameLayout parent, @NonNull PreviewTransformation previewTransform) {
        super(parent, previewTransform);
    }

    @Override
    void onSurfaceRequested(@NonNull SurfaceRequest surfaceRequest, @Nullable PreviewViewImplementation.OnSurfaceNotInUseListener onSurfaceNotInUseListener) {
        this.mResolution = surfaceRequest.getResolution();
        this.mOnSurfaceNotInUseListener = onSurfaceNotInUseListener;
        this.initializePreview();
        surfaceRequest.addRequestCancellationListener(ContextCompat.getMainExecutor((Context)this.mSurfaceView.getContext()), this::notifySurfaceNotInUse);
        this.mSurfaceView.post(() -> this.mSurfaceRequestCallback.setSurfaceRequest(surfaceRequest));
    }

    @Override
    void initializePreview() {
        Preconditions.checkNotNull((Object)this.mParent);
        Preconditions.checkNotNull((Object)this.mResolution);
        this.mSurfaceView = new SurfaceView(this.mParent.getContext());
        this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.mResolution.getWidth(), this.mResolution.getHeight()));
        this.mParent.removeAllViews();
        this.mParent.addView((View)this.mSurfaceView);
        this.mSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)this.mSurfaceRequestCallback);
    }

    @Override
    @Nullable
    View getPreview() {
        return this.mSurfaceView;
    }

    @Override
    void onAttachedToWindow() {
    }

    @Override
    void onDetachedFromWindow() {
    }

    void notifySurfaceNotInUse() {
        if (this.mOnSurfaceNotInUseListener != null) {
            this.mOnSurfaceNotInUseListener.onSurfaceNotInUse();
            this.mOnSurfaceNotInUseListener = null;
        }
    }

    @Override
    @RequiresApi(value=24)
    @Nullable
    Bitmap getPreviewBitmap() {
        if (this.mSurfaceView == null || this.mSurfaceView.getHolder().getSurface() == null || !this.mSurfaceView.getHolder().getSurface().isValid()) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)this.mSurfaceView.getWidth(), (int)this.mSurfaceView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Api24Impl.pixelCopyRequest(this.mSurfaceView, bitmap, copyResult -> {
            if (copyResult == 0) {
                Logger.d((String)TAG, (String)"PreviewView.SurfaceViewImplementation.getBitmap() succeeded");
            } else {
                Logger.e((String)TAG, (String)("PreviewView.SurfaceViewImplementation.getBitmap() failed with error " + copyResult));
            }
        }, this.mSurfaceView.getHandler());
        return bitmap;
    }

    @Override
    @NonNull
    ListenableFuture<Void> waitForNextFrame() {
        return Futures.immediateFuture(null);
    }

    @Override
    void setFrameUpdateListener(@NonNull Executor executor, @NonNull PreviewView.OnFrameUpdateListener listener) {
        throw new IllegalArgumentException("SurfaceView doesn't support frame update listener");
    }

    @RequiresApi(value=24)
    private static class Api24Impl {
        private Api24Impl() {
        }

        @DoNotInline
        static void pixelCopyRequest(@NonNull SurfaceView source, @NonNull Bitmap dest, @NonNull PixelCopy.OnPixelCopyFinishedListener listener, @NonNull Handler handler) {
            PixelCopy.request((SurfaceView)source, (Bitmap)dest, (PixelCopy.OnPixelCopyFinishedListener)listener, (Handler)handler);
        }
    }

    @RequiresApi(value=21)
    class SurfaceRequestCallback
    implements SurfaceHolder.Callback {
        @Nullable
        private Size mTargetSize;
        @Nullable
        private SurfaceRequest mSurfaceRequest;
        @Nullable
        private Size mCurrentSurfaceSize;
        private boolean mWasSurfaceProvided = false;

        SurfaceRequestCallback() {
        }

        @UiThread
        void setSurfaceRequest(@NonNull SurfaceRequest surfaceRequest) {
            Size targetSize;
            this.cancelPreviousRequest();
            this.mSurfaceRequest = surfaceRequest;
            this.mTargetSize = targetSize = surfaceRequest.getResolution();
            this.mWasSurfaceProvided = false;
            if (!this.tryToComplete()) {
                Logger.d((String)SurfaceViewImplementation.TAG, (String)"Wait for new Surface creation.");
                SurfaceViewImplementation.this.mSurfaceView.getHolder().setFixedSize(targetSize.getWidth(), targetSize.getHeight());
            }
        }

        @UiThread
        private boolean tryToComplete() {
            Surface surface = SurfaceViewImplementation.this.mSurfaceView.getHolder().getSurface();
            if (this.canProvideSurface()) {
                Logger.d((String)SurfaceViewImplementation.TAG, (String)"Surface set on Preview.");
                this.mSurfaceRequest.provideSurface(surface, ContextCompat.getMainExecutor((Context)SurfaceViewImplementation.this.mSurfaceView.getContext()), result -> {
                    Logger.d((String)SurfaceViewImplementation.TAG, (String)"Safe to release surface.");
                    SurfaceViewImplementation.this.notifySurfaceNotInUse();
                });
                this.mWasSurfaceProvided = true;
                SurfaceViewImplementation.this.onSurfaceProvided();
                return true;
            }
            return false;
        }

        private boolean canProvideSurface() {
            return !this.mWasSurfaceProvided && this.mSurfaceRequest != null && this.mTargetSize != null && this.mTargetSize.equals((Object)this.mCurrentSurfaceSize);
        }

        @UiThread
        private void cancelPreviousRequest() {
            if (this.mSurfaceRequest != null) {
                Logger.d((String)SurfaceViewImplementation.TAG, (String)("Request canceled: " + this.mSurfaceRequest));
                this.mSurfaceRequest.willNotProvideSurface();
            }
        }

        @UiThread
        private void invalidateSurface() {
            if (this.mSurfaceRequest != null) {
                Logger.d((String)SurfaceViewImplementation.TAG, (String)("Surface invalidated " + this.mSurfaceRequest));
                this.mSurfaceRequest.getDeferrableSurface().close();
            }
        }

        public void surfaceCreated(@NonNull SurfaceHolder surfaceHolder) {
            Logger.d((String)SurfaceViewImplementation.TAG, (String)"Surface created.");
        }

        public void surfaceChanged(@NonNull SurfaceHolder surfaceHolder, int format, int width, int height) {
            Logger.d((String)SurfaceViewImplementation.TAG, (String)("Surface changed. Size: " + width + "x" + height));
            this.mCurrentSurfaceSize = new Size(width, height);
            this.tryToComplete();
        }

        public void surfaceDestroyed(@NonNull SurfaceHolder surfaceHolder) {
            Logger.d((String)SurfaceViewImplementation.TAG, (String)"Surface destroyed.");
            if (this.mWasSurfaceProvided) {
                this.invalidateSurface();
            } else {
                this.cancelPreviousRequest();
            }
            this.mWasSurfaceProvided = false;
            this.mSurfaceRequest = null;
            this.mCurrentSurfaceSize = null;
            this.mTargetSize = null;
        }
    }
}

