/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin;

import androidx.compose.compiler.plugins.kotlin.ComposeErrors;
import androidx.compose.compiler.plugins.kotlin.ComposeFqNames;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Landroidx/compose/compiler/plugins/kotlin/UnionAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "checkType", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "getUnionTypes", "", "type", "Companion", "compose-compiler-hosted"})
public class UnionAnnotationChecker
implements AdditionalTypeChecker {
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private static final FqName UNIONTYPE_ANNOTATION_NAME;
    public static final Companion Companion;

    public void checkType(@NotNull KtExpression expression, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expressionType, (String)"expressionType");
        Intrinsics.checkNotNullParameter((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"c.expectedType");
        KotlinType expectedType = kotlinType;
        if (TypeUtils.noExpectedType((KotlinType)expectedType)) {
            return;
        }
        if (!expectedType.getAnnotations().hasAnnotation(UNIONTYPE_ANNOTATION_NAME) && !expressionTypeWithSmartCast.getAnnotations().hasAnnotation(UNIONTYPE_ANNOTATION_NAME)) {
            return;
        }
        List<KotlinType> expressionTypes = this.getUnionTypes(expressionTypeWithSmartCast);
        List<KotlinType> permittedTypes = this.getUnionTypes(expectedType);
        block0: for (KotlinType potentialExpressionType : expressionTypes) {
            for (KotlinType permittedType : permittedTypes) {
                if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(potentialExpressionType, permittedType)) continue;
                continue block0;
            }
            c.trace.report((Diagnostic)ComposeErrors.ILLEGAL_ASSIGN_TO_UNIONTYPE.on((PsiElement)expression, (Object)CollectionsKt.listOf((Object)potentialExpressionType), permittedTypes));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<KotlinType> getUnionTypes(KotlinType type) {
        void $this$mapTo$iv$iv;
        AnnotationDescriptor annotationDescriptor = type.getAnnotations().findAnnotation(UNIONTYPE_ANNOTATION_NAME);
        if (annotationDescriptor == null) {
            return CollectionsKt.listOf((Object)type);
        }
        AnnotationDescriptor annotation = annotationDescriptor;
        Object v = annotation.getAllValueArguments().get(Name.identifier((String)"types"));
        if (v == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.constants.ArrayValue");
        }
        ArrayValue types = (ArrayValue)v;
        Iterable $this$map$iv = (Iterable)types.getValue();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConstantValue constantValue = (ConstantValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KotlinType kotlinType = ((TypeProjection)CollectionsKt.single((List)it.getType(this.moduleDescriptor).getArguments())).getType();
            collection.add(kotlinType);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    public UnionAnnotationChecker(@NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        this.moduleDescriptor = moduleDescriptor;
    }

    static {
        Companion = new Companion(null);
        UNIONTYPE_ANNOTATION_NAME = ComposeFqNames.INSTANCE.fqNameFor("UnionType");
    }

    public void checkReceiver(@NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, boolean safeAccess, @NotNull CallResolutionContext<?> c) {
        Intrinsics.checkNotNullParameter((Object)receiverParameter, (String)"receiverParameter");
        Intrinsics.checkNotNullParameter((Object)receiverArgument, (String)"receiverArgument");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        AdditionalTypeChecker.DefaultImpls.checkReceiver((AdditionalTypeChecker)this, (ReceiverParameterDescriptor)receiverParameter, (ReceiverValue)receiverArgument, (boolean)safeAccess, c);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/compiler/plugins/kotlin/UnionAnnotationChecker$Companion;", "", "()V", "UNIONTYPE_ANNOTATION_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getUNIONTYPE_ANNOTATION_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "compose-compiler-hosted"})
    public static final class Companion {
        @NotNull
        public final FqName getUNIONTYPE_ANNOTATION_NAME() {
            return UNIONTYPE_ANNOTATION_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

