/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin;

import androidx.compose.compiler.plugins.kotlin.ComposeFqNames;
import androidx.compose.compiler.plugins.kotlin.IncompatibleComposeRuntimeVersionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/compose/compiler/plugins/kotlin/VersionChecker;", "", "context", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "(Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;)V", "compilerVersion", "", "getContext", "()Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "minimumRuntimeVersion", "getMinimumRuntimeVersion", "()Ljava/lang/String;", "minimumRuntimeVersionInt", "", "versionTable", "", "check", "", "noRuntimeOnClasspathError", "", "outdatedRuntime", "actualVersion", "outdatedRuntimeWithUnknownVersionNumber", "compose-compiler-hosted"})
public final class VersionChecker {
    private final Map<Integer, String> versionTable;
    private final int minimumRuntimeVersionInt;
    private final String compilerVersion;
    @NotNull
    private final IrPluginContext context;

    private final String getMinimumRuntimeVersion() {
        String string = this.versionTable.get(this.minimumRuntimeVersionInt);
        if (string == null) {
            string = "unknown";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void check() {
        IrConst versionExpr;
        IrExpression irExpression;
        IrProperty irProperty;
        Object v3;
        block10: {
            void $this$mapNotNullTo$iv$iv;
            IrClassSymbol versionClass = this.context.referenceClass(ComposeFqNames.INSTANCE.getComposeVersion());
            if (versionClass == null) {
                IrClassSymbol composerClass = this.context.referenceClass(ComposeFqNames.INSTANCE.getComposer());
                if (composerClass == null) {
                    Void void_ = this.outdatedRuntimeWithUnknownVersionNumber();
                    throw new KotlinNothingValueException();
                }
                Void void_ = this.noRuntimeOnClasspathError();
                throw new KotlinNothingValueException();
            }
            Iterable $this$mapNotNull$iv = ((IrClass)versionClass.getOwner()).getDeclarations();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                IrProperty irProperty2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                IrDeclaration it = (IrDeclaration)element$iv$iv;
                boolean bl2 = false;
                IrDeclaration irDeclaration = it;
                if (!(irDeclaration instanceof IrProperty)) {
                    irDeclaration = null;
                }
                if ((IrProperty)irDeclaration == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                IrProperty it$iv$iv = irProperty2;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IrProperty it = (IrProperty)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)"version")) continue;
                v3 = element$iv;
                break block10;
            }
            v3 = null;
        }
        if (!(((irProperty = (IrProperty)v3) != null && (irProperty = irProperty.getBackingField()) != null && (irProperty = irProperty.getInitializer()) != null ? irProperty.getExpression() : (irExpression = null)) instanceof IrConst)) {
            irExpression = null;
        }
        if ((versionExpr = (IrConst)irExpression) == null || Intrinsics.areEqual((Object)versionExpr.getKind(), (Object)IrConstKind.Int.INSTANCE) ^ true) {
            Void void_ = this.outdatedRuntimeWithUnknownVersionNumber();
            throw new KotlinNothingValueException();
        }
        Object object = versionExpr.getValue();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }
        int versionInt = (Integer)object;
        if (versionInt < this.minimumRuntimeVersionInt) {
            String string = this.versionTable.get(versionInt);
            if (string == null) {
                string = "<unknown>";
            }
            Void void_ = this.outdatedRuntime(string);
            throw new KotlinNothingValueException();
        }
    }

    private final Void noRuntimeOnClasspathError() {
        throw (Throwable)new IncompatibleComposeRuntimeVersionException(StringsKt.replace$default((String)StringsKt.trimIndent((String)("\n                The Compose Compiler requires the Compose Runtime to be on the class path, but\n                none could be found. The compose compiler plugin you are using (version\n                " + this.compilerVersion + ") expects a minimum runtime version of " + this.getMinimumRuntimeVersion() + ".\n            ")), (char)'\n', (char)' ', (boolean)false, (int)4, null));
    }

    private final Void outdatedRuntimeWithUnknownVersionNumber() {
        throw (Throwable)new IncompatibleComposeRuntimeVersionException(StringsKt.replace$default((String)StringsKt.trimIndent((String)("\n                You are using an outdated version of Compose Runtime that is not compatible with\n                the version of the Compose Compiler plugin you have installed. The compose\n                compiler plugin you are using (version " + this.compilerVersion + ") expects a minimum runtime\n                version of " + this.getMinimumRuntimeVersion() + ".\n            ")), (char)'\n', (char)' ', (boolean)false, (int)4, null));
    }

    private final Void outdatedRuntime(String actualVersion) {
        throw (Throwable)new IncompatibleComposeRuntimeVersionException(StringsKt.replace$default((String)StringsKt.trimIndent((String)("\n                You are using an outdated version of Compose Runtime that is not compatible with\n                the version of the Compose Compiler plugin you have installed. The compose\n                compiler plugin you are using (version " + this.compilerVersion + ") expects a minimum runtime\n                version of " + this.getMinimumRuntimeVersion() + ". The version of the runtime on the classpath\n                currently is " + actualVersion + ".\n            ")), (char)'\n', (char)' ', (boolean)false, (int)4, null));
    }

    @NotNull
    public final IrPluginContext getContext() {
        return this.context;
    }

    public VersionChecker(@NotNull IrPluginContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.versionTable = MapsKt.mapOf((Pair)TuplesKt.to((Object)1600, (Object)"0.1.0-dev16"));
        this.minimumRuntimeVersionInt = 1600;
        this.compilerVersion = "0.1.0-dev16";
    }
}

