/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.frames;

import androidx.compose.Immutable;
import androidx.compose.frames.FrameIdSetKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB$\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/compose/frames/FrameIdSet;", "", "upperSet", "", "lowerSet", "lowerBound", "", "belowBound", "", "clear", "bit", "get", "", "set", "Companion", "compose-runtime_release"})
@Immutable
public final class FrameIdSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long upperSet;
    private final long lowerSet;
    private final int lowerBound;
    private final int[] belowBound;
    private static final FrameIdSet EMPTY = new FrameIdSet(0L, 0L, 0, null);

    private FrameIdSet(long upperSet, long lowerSet, int lowerBound, int[] belowBound) {
        this.upperSet = upperSet;
        this.lowerSet = lowerSet;
        this.lowerBound = lowerBound;
        this.belowBound = belowBound;
    }

    public final boolean get(int bit) {
        Boolean bl;
        int offset = bit - this.lowerBound;
        if (offset >= 0 && offset < 64) {
            return (1L << offset & this.lowerSet) != 0L;
        }
        if (offset >= 64 && offset < 128) {
            return (1L << offset - 64 & this.upperSet) != 0L;
        }
        if (offset > 0) {
            return false;
        }
        int[] nArray = this.belowBound;
        if (nArray == null) {
            bl = null;
        } else {
            int[] nArray2 = nArray;
            boolean bl2 = false;
            boolean bl3 = false;
            int[] it = nArray2;
            boolean bl4 = false;
            bl = FrameIdSetKt.binarySearch(it, bit) >= 0;
        }
        Boolean bl5 = bl;
        return bl5 == null ? false : bl5;
    }

    @NotNull
    public final FrameIdSet set(int bit) {
        int offset = bit - this.lowerBound;
        if (offset >= 0 && offset < 64) {
            long mask = 1L << offset;
            if ((this.lowerSet & mask) == 0L) {
                return new FrameIdSet(this.upperSet, this.lowerSet | mask, this.lowerBound, this.belowBound);
            }
        } else if (offset >= 64 && offset < 128) {
            long mask = 1L << offset - 64;
            if ((this.upperSet & mask) == 0L) {
                return new FrameIdSet(this.upperSet | mask, this.lowerSet, this.lowerBound, this.belowBound);
            }
        } else if (offset >= 128) {
            if (!this.get(bit)) {
                List list;
                long newUpperSet = this.upperSet;
                Ref.LongRef longRef = new Ref.LongRef();
                longRef.element = this.lowerSet;
                Ref.IntRef newLowerBound = new Ref.IntRef();
                newLowerBound.element = this.lowerBound;
                Ref.ObjectRef newBelowBound = new Ref.ObjectRef();
                newBelowBound.element = null;
                int targetLowerBound = (bit + 1) / 64 * 64;
                while (newLowerBound.element < targetLowerBound) {
                    if (longRef.element != 0L) {
                        int n;
                        boolean bl;
                        int n2;
                        if ((List)newBelowBound.element == null) {
                            List list2;
                            Ref.ObjectRef objectRef = newBelowBound;
                            n2 = 0;
                            List list3 = list2 = (List)new ArrayList();
                            bl = false;
                            n = 0;
                            List $this$set_u24lambda_u2d3 = list3;
                            boolean bl2 = false;
                            int[] nArray = this.belowBound;
                            if (nArray != null) {
                                int[] nArray2 = nArray;
                                boolean bl3 = false;
                                boolean bl4 = false;
                                int[] it = nArray2;
                                boolean bl5 = false;
                                int[] $this$forEach$iv = it;
                                boolean $i$f$forEach = false;
                                int[] nArray3 = $this$forEach$iv;
                                int n3 = nArray3.length;
                                for (int i = 0; i < n3; ++i) {
                                    int element$iv;
                                    int it2 = element$iv = nArray3[i];
                                    boolean bl6 = false;
                                    $this$set_u24lambda_u2d3.add(it2);
                                }
                            }
                            list2 = list3;
                            objectRef.element = list2;
                        }
                        n2 = 64;
                        bl = false;
                        n = 0;
                        int n4 = n2;
                        for (n = 0; n < n4; ++n) {
                            int bitOffset = n;
                            boolean bl7 = false;
                            if ((longRef.element & 1L << bitOffset) == 0L) continue;
                            ((List)newBelowBound.element).add(bitOffset + newLowerBound.element);
                        }
                    }
                    if (newUpperSet == 0L) {
                        newLowerBound.element = targetLowerBound;
                        longRef.element = 0L;
                        break;
                    }
                    longRef.element = newUpperSet;
                    newUpperSet = 0L;
                    newLowerBound.element += 64;
                }
                int[] nArray = (list = (List)newBelowBound.element) == null ? (int[])null : CollectionsKt.toIntArray((Collection)list);
                return new FrameIdSet(newUpperSet, longRef.element, newLowerBound.element, nArray == null ? this.belowBound : nArray).set(bit);
            }
        } else {
            int[] nArray = this.belowBound;
            if (nArray == null) {
                int[] nArray4 = new int[]{bit};
                return new FrameIdSet(this.upperSet, this.lowerSet, this.lowerBound, nArray4);
            }
            int[] array = nArray;
            int location = FrameIdSetKt.binarySearch(array, bit);
            if (location < 0) {
                int insertLocation = -(location + 1);
                int newSize = array.length + 1;
                int[] newBelowBound = new int[newSize];
                ArraysKt.copyInto((int[])array, (int[])newBelowBound, (int)0, (int)0, (int)insertLocation);
                ArraysKt.copyInto((int[])array, (int[])newBelowBound, (int)(insertLocation + 1), (int)insertLocation, (int)(newSize - 1));
                newBelowBound[insertLocation] = bit;
                return new FrameIdSet(this.upperSet, this.lowerSet, this.lowerBound, newBelowBound);
            }
        }
        return this;
    }

    @NotNull
    public final FrameIdSet clear(int bit) {
        int location;
        int[] array;
        int offset = bit - this.lowerBound;
        if (offset >= 0 && offset < 64) {
            long mask = 1L << offset;
            if ((this.lowerSet & mask) != 0L) {
                return new FrameIdSet(this.upperSet, this.lowerSet & (mask ^ 0xFFFFFFFFFFFFFFFFL), this.lowerBound, this.belowBound);
            }
        } else if (offset >= 64 && offset < 128) {
            long mask = 1L << offset - 64;
            if ((this.upperSet & mask) != 0L) {
                return new FrameIdSet(this.upperSet & (mask ^ 0xFFFFFFFFFFFFFFFFL), this.lowerSet, this.lowerBound, this.belowBound);
            }
        } else if (offset < 0 && (array = this.belowBound) != null && (location = FrameIdSetKt.binarySearch(array, bit)) >= 0) {
            int newSize = array.length - 1;
            if (newSize == 0) {
                return new FrameIdSet(this.upperSet, this.lowerSet, this.lowerBound, null);
            }
            int[] newBelowBound = new int[newSize];
            if (location > 0) {
                ArraysKt.copyInto((int[])array, (int[])newBelowBound, (int)0, (int)0, (int)location);
            }
            if (location < newSize) {
                ArraysKt.copyInto((int[])array, (int[])newBelowBound, (int)location, (int)(location + 1), (int)(newSize + 1));
            }
            return new FrameIdSet(this.upperSet, this.lowerSet, this.lowerBound, newBelowBound);
        }
        return this;
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0002\b\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Landroidx/compose/frames/FrameIdSet$Companion;", "", "EMPTY", "Landroidx/compose/frames/FrameIdSet;", "getEMPTY", "()Landroidx/compose/frames/FrameIdSet;", "compose-runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrameIdSet getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(@NotNull DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

