/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.pager.MeasuredPage;
import androidx.compose.foundation.pager.PageInfo;
import androidx.compose.foundation.pager.PagerMeasureResult;
import androidx.compose.runtime.IntState;
import androidx.compose.runtime.MutableIntState;
import androidx.compose.runtime.SnapshotIntStateKt;
import androidx.compose.runtime.snapshots.Snapshot;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003J\u0018\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fR+\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00038F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR+\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00038F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\r\u001a\u0004\b\u000f\u0010\t\"\u0004\b\u0010\u0010\u000bR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00038F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\r\u001a\u0004\b\u0016\u0010\t\"\u0004\b\u0017\u0010\u000b\u00a8\u0006 "}, d2={"Landroidx/compose/foundation/pager/PagerScrollPosition;", "", "initialPage", "", "initialScrollOffset", "(II)V", "<set-?>", "currentPage", "getCurrentPage", "()I", "setCurrentPage", "(I)V", "currentPage$delegate", "Landroidx/compose/runtime/MutableIntState;", "firstVisiblePage", "getFirstVisiblePage", "setFirstVisiblePage", "firstVisiblePage$delegate", "hadFirstNotEmptyLayout", "", "lastKnownFirstPageKey", "scrollOffset", "getScrollOffset", "setScrollOffset", "scrollOffset$delegate", "requestPosition", "", "index", "update", "updateFromMeasureResult", "measureResult", "Landroidx/compose/foundation/pager/PagerMeasureResult;", "foundation_release"})
@SourceDebugExtension(value={"SMAP\nPagerScrollPosition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagerScrollPosition.kt\nandroidx/compose/foundation/pager/PagerScrollPosition\n+ 2 SnapshotIntState.kt\nandroidx/compose/runtime/SnapshotIntStateKt__SnapshotIntStateKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Snapshot.kt\nandroidx/compose/runtime/snapshots/Snapshot$Companion\n+ 5 Snapshot.kt\nandroidx/compose/runtime/snapshots/Snapshot\n*L\n1#1,99:1\n75#2:100\n107#2,2:101\n75#2:103\n107#2,2:104\n75#2:106\n107#2,2:107\n1#3:109\n488#4,4:110\n493#4:119\n122#5,5:114\n*S KotlinDebug\n*F\n+ 1 PagerScrollPosition.kt\nandroidx/compose/foundation/pager/PagerScrollPosition\n*L\n34#1:100\n34#1:101,2\n35#1:103\n35#1:104,2\n37#1:106\n37#1:107,2\n58#1:110,4\n58#1:119\n58#1:114,5\n*E\n"})
public final class PagerScrollPosition {
    @NotNull
    private final MutableIntState firstVisiblePage$delegate;
    @NotNull
    private final MutableIntState currentPage$delegate;
    @NotNull
    private final MutableIntState scrollOffset$delegate;
    private boolean hadFirstNotEmptyLayout;
    @Nullable
    private Object lastKnownFirstPageKey;

    public PagerScrollPosition(int initialPage, int initialScrollOffset) {
        this.firstVisiblePage$delegate = SnapshotIntStateKt.mutableIntStateOf((int)initialPage);
        this.currentPage$delegate = SnapshotIntStateKt.mutableIntStateOf((int)initialPage);
        this.scrollOffset$delegate = SnapshotIntStateKt.mutableIntStateOf((int)initialScrollOffset);
    }

    public /* synthetic */ PagerScrollPosition(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        this(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final int getFirstVisiblePage() {
        void $this$getValue$iv;
        IntState intState = (IntState)this.firstVisiblePage$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getIntValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setFirstVisiblePage(int n) {
        void $this$setValue$iv;
        MutableIntState mutableIntState = this.firstVisiblePage$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setIntValue(n);
    }

    /*
     * WARNING - void declaration
     */
    public final int getCurrentPage() {
        void $this$getValue$iv;
        IntState intState = (IntState)this.currentPage$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getIntValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setCurrentPage(int n) {
        void $this$setValue$iv;
        MutableIntState mutableIntState = this.currentPage$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setIntValue(n);
    }

    /*
     * WARNING - void declaration
     */
    public final int getScrollOffset() {
        void $this$getValue$iv;
        IntState intState = (IntState)this.scrollOffset$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getIntValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setScrollOffset(int n) {
        void $this$setValue$iv;
        MutableIntState mutableIntState = this.scrollOffset$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setIntValue(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateFromMeasureResult(@NotNull PagerMeasureResult measureResult) {
        Intrinsics.checkNotNullParameter((Object)measureResult, (String)"measureResult");
        MeasuredPage measuredPage = measureResult.getFirstVisiblePage();
        Object object = this.lastKnownFirstPageKey = measuredPage != null ? measuredPage.getKey() : null;
        if (this.hadFirstNotEmptyLayout || measureResult.getPagesCount() > 0) {
            this.hadFirstNotEmptyLayout = true;
            int scrollOffset = measureResult.getFirstVisiblePageOffset();
            if (!((float)scrollOffset >= 0.0f)) {
                boolean $i$a$-check-PagerScrollPosition$updateFromMeasureResult$22 = false;
                String $i$a$-check-PagerScrollPosition$updateFromMeasureResult$22 = "scrollOffset should be non-negative (" + scrollOffset + ')';
                throw new IllegalStateException($i$a$-check-PagerScrollPosition$updateFromMeasureResult$22.toString());
            }
            Snapshot.Companion this_$iv = Snapshot.Companion;
            boolean $i$f$withoutReadObservation = false;
            Snapshot snapshot$iv = this_$iv.createNonObservableSnapshot();
            try {
                Unit unit;
                Snapshot this_$iv$iv = snapshot$iv;
                boolean $i$f$enter = false;
                Snapshot previous$iv$iv = this_$iv$iv.makeCurrent();
                try {
                    Unit unit2;
                    boolean bl = false;
                    MeasuredPage measuredPage2 = measureResult.getFirstVisiblePage();
                    this.update(measuredPage2 != null ? measuredPage2.getIndex() : 0, scrollOffset);
                    PageInfo pageInfo = measureResult.getClosestPageToSnapPosition();
                    if (pageInfo != null) {
                        int it = pageInfo.getIndex();
                        boolean bl2 = false;
                        if (it != this.getCurrentPage()) {
                            this.setCurrentPage(it);
                        }
                        unit2 = Unit.INSTANCE;
                    } else {
                        unit2 = null;
                    }
                    unit = unit2;
                }
                finally {
                    this_$iv$iv.restoreCurrent(previous$iv$iv);
                }
                Unit unit3 = unit;
            }
            finally {
                snapshot$iv.dispose();
            }
        }
    }

    public final void requestPosition(int index2, int scrollOffset) {
        this.update(index2, scrollOffset);
        this.lastKnownFirstPageKey = null;
    }

    private final void update(int index2, int scrollOffset) {
        if (!((float)index2 >= 0.0f)) {
            boolean bl = false;
            String string = "Index should be non-negative (" + index2 + ')';
            throw new IllegalArgumentException(string.toString());
        }
        if (index2 != this.getFirstVisiblePage()) {
            this.setFirstVisiblePage(index2);
        }
        if (scrollOffset != this.getScrollOffset()) {
            this.setScrollOffset(scrollOffset);
        }
    }

    public PagerScrollPosition() {
        this(0, 0, 3, null);
    }
}

