/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation;

import androidx.compose.foundation.ScrollState;
import androidx.compose.foundation.ScrollingLayoutNode;
import androidx.compose.ui.node.ModifierNodeElement;
import androidx.compose.ui.platform.InspectorInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\u0002H\u0016J\u0013\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\f\u0010\u0015\u001a\u00020\u0013*\u00020\u0016H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\tR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Landroidx/compose/foundation/ScrollingLayoutElement;", "Landroidx/compose/ui/node/ModifierNodeElement;", "Landroidx/compose/foundation/ScrollingLayoutNode;", "scrollState", "Landroidx/compose/foundation/ScrollState;", "isReversed", "", "isVertical", "(Landroidx/compose/foundation/ScrollState;ZZ)V", "()Z", "getScrollState", "()Landroidx/compose/foundation/ScrollState;", "create", "equals", "other", "", "hashCode", "", "update", "", "node", "inspectableProperties", "Landroidx/compose/ui/platform/InspectorInfo;", "foundation_release"})
public final class ScrollingLayoutElement
extends ModifierNodeElement<ScrollingLayoutNode> {
    @NotNull
    private final ScrollState scrollState;
    private final boolean isReversed;
    private final boolean isVertical;

    public ScrollingLayoutElement(@NotNull ScrollState scrollState, boolean isReversed, boolean isVertical) {
        Intrinsics.checkNotNullParameter((Object)scrollState, (String)"scrollState");
        this.scrollState = scrollState;
        this.isReversed = isReversed;
        this.isVertical = isVertical;
    }

    @NotNull
    public final ScrollState getScrollState() {
        return this.scrollState;
    }

    public final boolean isReversed() {
        return this.isReversed;
    }

    public final boolean isVertical() {
        return this.isVertical;
    }

    @NotNull
    public ScrollingLayoutNode create() {
        return new ScrollingLayoutNode(this.scrollState, this.isReversed, this.isVertical);
    }

    public void update(@NotNull ScrollingLayoutNode node) {
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        node.setScrollerState(this.scrollState);
        node.setReversed(this.isReversed);
        node.setVertical(this.isVertical);
    }

    public int hashCode() {
        int result2 = this.scrollState.hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.isReversed);
        result2 = 31 * result2 + Boolean.hashCode(this.isVertical);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ScrollingLayoutElement)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.scrollState, (Object)((ScrollingLayoutElement)((Object)other)).scrollState) && this.isReversed == ((ScrollingLayoutElement)((Object)other)).isReversed && this.isVertical == ((ScrollingLayoutElement)((Object)other)).isVertical;
    }

    public void inspectableProperties(@NotNull InspectorInfo $this$inspectableProperties) {
        Intrinsics.checkNotNullParameter((Object)$this$inspectableProperties, (String)"<this>");
        $this$inspectableProperties.setName("layoutInScroll");
        $this$inspectableProperties.getProperties().set("state", (Object)this.scrollState);
        $this$inspectableProperties.getProperties().set("isReversed", (Object)this.isReversed);
        $this$inspectableProperties.getProperties().set("isVertical", (Object)this.isVertical);
    }
}

