/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text2.input;

import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.text2.input.TextFieldBuffer;
import androidx.compose.foundation.text2.input.TextFieldCharSequence;
import androidx.compose.foundation.text2.input.TextFieldCharSequenceKt;
import androidx.compose.foundation.text2.input.internal.ChangeTracker;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0017\b\u0007\u0018\u00002\u00020\u0001B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J%\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0018J\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0018J\u0006\u0010\u001e\u001a\u00020\u0015J\u0006\u0010\u001f\u001a\u00020\u0015J\u000e\u0010 \u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0018J\u000e\u0010!\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0018J\u0006\u0010\"\u001a\u00020\u0015J\u0006\u0010#\u001a\u00020\u0015J\u0006\u0010$\u001a\u00020\u0015J\u0006\u0010%\u001a\u00020\u0015J\u001b\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\r\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b(\u0010)J\u001b\u0010*\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\r\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b+\u0010)J\u001f\u0010,\u001a\u00020\u00032\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\rH\u0000\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0002\b.R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR)\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\u00020\r8F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006/"}, d2={"Landroidx/compose/foundation/text2/input/TextFieldBufferWithSelection;", "Landroidx/compose/foundation/text2/input/TextFieldBuffer;", "value", "Landroidx/compose/foundation/text2/input/TextFieldCharSequence;", "sourceValue", "initialChanges", "Landroidx/compose/foundation/text2/input/internal/ChangeTracker;", "(Landroidx/compose/foundation/text2/input/TextFieldCharSequence;Landroidx/compose/foundation/text2/input/TextFieldCharSequence;Landroidx/compose/foundation/text2/input/internal/ChangeTracker;)V", "hasSelection", "", "getHasSelection", "()Z", "<set-?>", "Landroidx/compose/ui/text/TextRange;", "selectionInChars", "getSelectionInChars-d9O1mEE", "()J", "J", "selectionInCodepoints", "getSelectionInCodepoints-d9O1mEE", "onTextWillChange", "", "rangeToBeReplaced", "newLength", "", "onTextWillChange-72CqOWE", "(JI)V", "placeCursorAfterCharAt", "index", "placeCursorAfterCodepointAt", "placeCursorAfterLastChange", "placeCursorAtEnd", "placeCursorBeforeCharAt", "placeCursorBeforeCodepointAt", "placeCursorBeforeFirstChange", "revertAllChanges", "selectAll", "selectAllChanges", "selectCharsIn", "range", "selectCharsIn-5zc-tL8", "(J)V", "selectCodepointsIn", "selectCodepointsIn-5zc-tL8", "toTextFieldCharSequence", "composition", "toTextFieldCharSequence-OEnZFl4$foundation_release", "foundation_release"})
@ExperimentalFoundationApi
@StabilityInferred(parameters=0)
public final class TextFieldBufferWithSelection
extends TextFieldBuffer {
    @NotNull
    private final TextFieldCharSequence sourceValue;
    private long selectionInChars;
    public static final int $stable = 8;

    public TextFieldBufferWithSelection(@NotNull TextFieldCharSequence value, @NotNull TextFieldCharSequence sourceValue, @Nullable ChangeTracker initialChanges) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)sourceValue, (String)"sourceValue");
        super(value, initialChanges);
        this.sourceValue = sourceValue;
        this.selectionInChars = value.getSelectionInChars-d9O1mEE();
    }

    public /* synthetic */ TextFieldBufferWithSelection(TextFieldCharSequence textFieldCharSequence, TextFieldCharSequence textFieldCharSequence2, ChangeTracker changeTracker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            textFieldCharSequence2 = TextFieldCharSequenceKt.TextFieldCharSequence-FDrldGo$default(null, 0L, 3, null);
        }
        if ((n & 4) != 0) {
            changeTracker = null;
        }
        this(textFieldCharSequence, textFieldCharSequence2, changeTracker);
    }

    public final boolean getHasSelection() {
        return !TextRange.getCollapsed-impl((long)this.selectionInChars);
    }

    public final long getSelectionInChars-d9O1mEE() {
        return this.selectionInChars;
    }

    public final long getSelectionInCodepoints-d9O1mEE() {
        return this.charsToCodepoints-GEjPoXI$foundation_release(this.selectionInChars);
    }

    public final void placeCursorBeforeCodepointAt(int index2) {
        this.requireValidIndex$foundation_release(index2, true);
        int charIndex = this.codepointIndexToCharIndex$foundation_release(index2);
        this.selectionInChars = TextRangeKt.TextRange((int)charIndex);
    }

    public final void placeCursorBeforeCharAt(int index2) {
        this.requireValidIndex$foundation_release(index2, false);
        this.selectionInChars = TextRangeKt.TextRange((int)index2);
    }

    public final void placeCursorAfterCodepointAt(int index2) {
        this.requireValidIndex$foundation_release(index2, true);
        int charIndex = this.codepointIndexToCharIndex$foundation_release(RangesKt.coerceAtMost((int)(index2 + 1), (int)this.getCodepointLength()));
        this.selectionInChars = TextRangeKt.TextRange((int)charIndex);
    }

    public final void placeCursorAfterCharAt(int index2) {
        this.requireValidIndex$foundation_release(index2, false);
        this.selectionInChars = TextRangeKt.TextRange((int)RangesKt.coerceAtMost((int)(index2 + 1), (int)this.length()));
    }

    public final void placeCursorAtEnd() {
        this.selectionInChars = TextRangeKt.TextRange((int)this.length());
    }

    public final void placeCursorAfterLastChange() {
        if (this.getChanges().getChangeCount() > 0) {
            this.placeCursorBeforeCharAt(TextRange.getMax-impl((long)this.getChanges().getRange--jx7JFs(this.getChanges().getChangeCount())));
        }
    }

    public final void placeCursorBeforeFirstChange() {
        if (this.getChanges().getChangeCount() > 0) {
            this.placeCursorBeforeCharAt(TextRange.getMin-impl((long)this.getChanges().getRange--jx7JFs(0)));
        }
    }

    public final void selectCodepointsIn-5zc-tL8(long range) {
        this.requireValidRange-72CqOWE$foundation_release(range, true);
        this.selectionInChars = this.codepointsToChars-GEjPoXI$foundation_release(range);
    }

    public final void selectCharsIn-5zc-tL8(long range) {
        this.requireValidRange-72CqOWE$foundation_release(range, false);
        this.selectionInChars = range;
    }

    public final void selectAll() {
        this.selectionInChars = TextRangeKt.TextRange((int)0, (int)this.length());
    }

    public final void selectAllChanges() {
        if (this.getChanges().getChangeCount() > 0) {
            this.selectCharsIn-5zc-tL8(TextRangeKt.TextRange((int)TextRange.getMin-impl((long)this.getChanges().getRange--jx7JFs(0)), (int)TextRange.getMax-impl((long)this.getChanges().getRange--jx7JFs(this.getChanges().getChangeCount()))));
        }
    }

    public final void revertAllChanges() {
        this.replace(0, this.length(), ((Object)this.sourceValue).toString());
        this.selectionInChars = this.sourceValue.getSelectionInChars-d9O1mEE();
        this.clearChangeList$foundation_release();
    }

    @Override
    protected void onTextWillChange-72CqOWE(long rangeToBeReplaced, int newLength) {
        super.onTextWillChange-72CqOWE(rangeToBeReplaced, newLength);
        int start = TextRange.getMin-impl((long)rangeToBeReplaced);
        int end = TextRange.getMax-impl((long)rangeToBeReplaced);
        int selStart = TextRange.getMin-impl((long)this.selectionInChars);
        int selEnd = TextRange.getMax-impl((long)this.selectionInChars);
        if (selEnd < start) {
            return;
        }
        if (selStart <= start && end <= selEnd) {
            int diff = newLength - (end - start);
            if (selStart == selEnd) {
                selStart += diff;
            }
            selEnd += diff;
        } else if (selStart > start && selEnd < end) {
            selStart = start + newLength;
            selEnd = start + newLength;
        } else if (selStart >= end) {
            int diff = newLength - (end - start);
            selStart += diff;
            selEnd += diff;
        } else if (start < selStart) {
            selStart = start + newLength;
            selEnd += newLength - (end - start);
        } else {
            selEnd = start;
        }
        this.selectionInChars = TextRangeKt.TextRange((int)selStart, (int)selEnd);
    }

    @NotNull
    public final TextFieldCharSequence toTextFieldCharSequence-OEnZFl4$foundation_release(@Nullable TextRange composition) {
        return this.toTextFieldCharSequence-udt6zUU$foundation_release(this.selectionInChars, composition);
    }

    public static /* synthetic */ TextFieldCharSequence toTextFieldCharSequence-OEnZFl4$foundation_release$default(TextFieldBufferWithSelection textFieldBufferWithSelection, TextRange textRange, int n, Object object) {
        if ((n & 1) != 0) {
            textRange = null;
        }
        return textFieldBufferWithSelection.toTextFieldCharSequence-OEnZFl4$foundation_release(textRange);
    }
}

