/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text2.input.internal;

import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputContentInfo;
import androidx.compose.foundation.text2.input.TextFieldCharSequence;
import androidx.compose.foundation.text2.input.TextFieldCharSequenceKt;
import androidx.compose.foundation.text2.input.internal.CommitTextCommand;
import androidx.compose.foundation.text2.input.internal.DeleteSurroundingTextCommand;
import androidx.compose.foundation.text2.input.internal.DeleteSurroundingTextInCodePointsCommand;
import androidx.compose.foundation.text2.input.internal.EditCommand;
import androidx.compose.foundation.text2.input.internal.EditableTextInputSession;
import androidx.compose.foundation.text2.input.internal.FinishComposingTextCommand;
import androidx.compose.foundation.text2.input.internal.SetComposingRegionCommand;
import androidx.compose.foundation.text2.input.internal.SetComposingTextCommand;
import androidx.compose.foundation.text2.input.internal.SetSelectionCommand;
import androidx.compose.foundation.text2.input.internal.StatelessInputConnectionKt;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.input.ImeAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0002J\b\u0010\u0016\u001a\u00020\fH\u0016J\b\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016J\u0012\u0010\u001b\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\"\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00072\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0012\u0010$\u001a\u00020\f2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u001a\u0010'\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u0007H\u0016J\u0018\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u0007H\u0016J\u0018\u0010-\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u0007H\u0016J\b\u0010.\u001a\u00020\fH\u0016J\b\u0010/\u001a\u00020\fH\u0002J\u0017\u00100\u001a\u00020\f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003H\u0082\bJ\b\u00102\u001a\u00020\fH\u0016J\u0010\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0007H\u0016J\u001a\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u0001082\u0006\u0010!\u001a\u00020\u0007H\u0016J\n\u00109\u001a\u0004\u0018\u00010:H\u0016J\u0012\u0010;\u001a\u0004\u0018\u00010(2\u0006\u0010!\u001a\u00020\u0007H\u0016J\u0018\u0010<\u001a\u00020(2\u0006\u0010=\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007H\u0016J\u0018\u0010>\u001a\u00020(2\u0006\u0010=\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007H\u0016J\u0010\u0010?\u001a\u00020\u00142\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020\f2\u0006\u0010C\u001a\u00020\u0007H\u0016J\u0010\u0010D\u001a\u00020\f2\u0006\u0010E\u001a\u00020\u0007H\u0016J\u001c\u0010F\u001a\u00020\f2\b\u0010G\u001a\u0004\u0018\u00010A2\b\u0010H\u001a\u0004\u0018\u00010#H\u0016J\u0010\u0010I\u001a\u00020\f2\u0006\u0010J\u001a\u00020\fH\u0016J\u0010\u0010K\u001a\u00020\f2\u0006\u0010L\u001a\u00020\u0007H\u0016J\u0010\u0010M\u001a\u00020\f2\u0006\u0010N\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u00020\u00142\u0006\u0010Q\u001a\u00020\u0007H\u0002J\u0018\u0010R\u001a\u00020\f2\u0006\u0010S\u001a\u00020\u00072\u0006\u0010T\u001a\u00020\u0007H\u0016J\u001a\u0010U\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u0007H\u0016J\u0018\u0010V\u001a\u00020\f2\u0006\u0010S\u001a\u00020\u00072\u0006\u0010T\u001a\u00020\u0007H\u0016J\n\u0010;\u001a\u00020(*\u00020\u000eJ\u0012\u0010W\u001a\u00020(*\u00020\u000e2\u0006\u0010=\u001a\u00020\u0007J\u0012\u0010X\u001a\u00020(*\u00020\u000e2\u0006\u0010=\u001a\u00020\u0007R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006Y"}, d2={"Landroidx/compose/foundation/text2/input/internal/StatelessInputConnection;", "Landroid/view/inputmethod/InputConnection;", "activeSessionProvider", "Lkotlin/Function0;", "Landroidx/compose/foundation/text2/input/internal/EditableTextInputSession;", "(Lkotlin/jvm/functions/Function0;)V", "batchDepth", "", "editCommands", "", "Landroidx/compose/foundation/text2/input/internal/EditCommand;", "isICActive", "", "value", "Landroidx/compose/foundation/text2/input/TextFieldCharSequence;", "getValue", "()Landroidx/compose/foundation/text2/input/TextFieldCharSequence;", "valueOrNull", "getValueOrNull", "addEditCommandWithBatch", "", "editCommand", "beginBatchEdit", "beginBatchEditInternal", "clearMetaKeyStates", "states", "closeConnection", "commitCompletion", "text", "Landroid/view/inputmethod/CompletionInfo;", "commitContent", "inputContentInfo", "Landroid/view/inputmethod/InputContentInfo;", "flags", "opts", "Landroid/os/Bundle;", "commitCorrection", "correctionInfo", "Landroid/view/inputmethod/CorrectionInfo;", "commitText", "", "newCursorPosition", "deleteSurroundingText", "beforeLength", "afterLength", "deleteSurroundingTextInCodePoints", "endBatchEdit", "endBatchEditInternal", "ensureActive", "block", "finishComposingText", "getCursorCapsMode", "reqModes", "getExtractedText", "Landroid/view/inputmethod/ExtractedText;", "request", "Landroid/view/inputmethod/ExtractedTextRequest;", "getHandler", "Landroid/os/Handler;", "getSelectedText", "getTextAfterCursor", "maxChars", "getTextBeforeCursor", "logDebug", "message", "", "performContextMenuAction", "id", "performEditorAction", "editorAction", "performPrivateCommand", "action", "data", "reportFullscreenMode", "enabled", "requestCursorUpdates", "cursorUpdateMode", "sendKeyEvent", "event", "Landroid/view/KeyEvent;", "sendSynthesizedKeyEvent", "code", "setComposingRegion", "start", "end", "setComposingText", "setSelection", "getTextAfterSelection", "getTextBeforeSelection", "foundation_release"})
@SourceDebugExtension(value={"SMAP\nStatelessInputConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatelessInputConnection.kt\nandroidx/compose/foundation/text2/input/internal/StatelessInputConnection\n*L\n1#1,414:1\n96#1,6:415\n96#1,6:421\n96#1,6:427\n96#1,6:433\n96#1,6:439\n96#1,6:445\n96#1,6:451\n96#1,6:457\n96#1,6:463\n96#1,6:469\n96#1,6:475\n96#1,6:481\n96#1,6:487\n96#1,6:493\n*S KotlinDebug\n*F\n+ 1 StatelessInputConnection.kt\nandroidx/compose/foundation/text2/input/internal/StatelessInputConnection\n*L\n121#1:415,6\n157#1:421,6\n162#1:427,6\n168#1:433,6\n174#1:439,6\n183#1:445,6\n189#1:451,6\n195#1:457,6\n201#1:463,6\n237#1:469,6\n262#1:475,6\n288#1:481,6\n351#1:487,6\n360#1:493,6\n*E\n"})
public final class StatelessInputConnection
implements InputConnection {
    @NotNull
    private final Function0<EditableTextInputSession> activeSessionProvider;
    private int batchDepth;
    @NotNull
    private final List<EditCommand> editCommands;
    private boolean isICActive;

    public StatelessInputConnection(@NotNull Function0<? extends EditableTextInputSession> activeSessionProvider) {
        Intrinsics.checkNotNullParameter(activeSessionProvider, (String)"activeSessionProvider");
        this.activeSessionProvider = activeSessionProvider;
        this.editCommands = new ArrayList();
        this.isICActive = true;
    }

    private final TextFieldCharSequence getValueOrNull() {
        EditableTextInputSession editableTextInputSession = (EditableTextInputSession)this.activeSessionProvider.invoke();
        return editableTextInputSession != null ? editableTextInputSession.getValue() : null;
    }

    private final TextFieldCharSequence getValue() {
        TextFieldCharSequence textFieldCharSequence = this.getValueOrNull();
        if (textFieldCharSequence == null) {
            textFieldCharSequence = TextFieldCharSequenceKt.TextFieldCharSequence-FDrldGo$default(null, 0L, 3, null);
        }
        return textFieldCharSequence;
    }

    private final boolean ensureActive(Function0<Unit> block2) {
        boolean combinedActive;
        boolean bl;
        boolean $i$f$ensureActive = false;
        boolean it = bl = (combinedActive = this.isICActive && this.activeSessionProvider.invoke() != null);
        boolean bl2 = false;
        if (it) {
            block2.invoke();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addEditCommandWithBatch(EditCommand editCommand) {
        this.beginBatchEditInternal();
        try {
            this.editCommands.add(editCommand);
        }
        finally {
            this.endBatchEditInternal();
        }
    }

    public boolean beginBatchEdit() {
        boolean combinedActive$iv;
        boolean bl;
        StatelessInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean it$iv = bl = (combinedActive$iv = this_$iv.isICActive && this_$iv.activeSessionProvider.invoke() != null);
        boolean bl2 = false;
        if (it$iv) {
            boolean bl3 = false;
            this.logDebug("beginBatchEdit()");
            return this.beginBatchEditInternal();
        }
        return bl;
    }

    private final boolean beginBatchEditInternal() {
        int n = this.batchDepth;
        this.batchDepth = n + 1;
        return true;
    }

    public boolean endBatchEdit() {
        this.logDebug("endBatchEdit()");
        return this.endBatchEditInternal();
    }

    private final boolean endBatchEditInternal() {
        int n = this.batchDepth;
        this.batchDepth = n + -1;
        if (this.batchDepth == 0 && !((Collection)this.editCommands).isEmpty()) {
            EditableTextInputSession editableTextInputSession = (EditableTextInputSession)this.activeSessionProvider.invoke();
            if (editableTextInputSession != null) {
                editableTextInputSession.requestEdits(CollectionsKt.toMutableList((Collection)this.editCommands));
            }
            this.editCommands.clear();
        }
        return this.batchDepth > 0;
    }

    public void closeConnection() {
        this.logDebug("closeConnection()");
        this.editCommands.clear();
        this.batchDepth = 0;
        this.isICActive = false;
    }

    public boolean commitText(@Nullable CharSequence text, int newCursorPosition) {
        boolean combinedActive$iv;
        boolean bl;
        StatelessInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean it$iv = bl = (combinedActive$iv = this_$iv.isICActive && this_$iv.activeSessionProvider.invoke() != null);
        boolean bl2 = false;
        if (it$iv) {
            boolean bl3 = false;
            this.logDebug("commitText(\"" + text + "\", " + newCursorPosition + ')');
            this.addEditCommandWithBatch(new CommitTextCommand(String.valueOf(text), newCursorPosition));
        }
        return bl;
    }

    public boolean setComposingRegion(int start, int end) {
        boolean combinedActive$iv;
        boolean bl;
        StatelessInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean it$iv = bl = (combinedActive$iv = this_$iv.isICActive && this_$iv.activeSessionProvider.invoke() != null);
        boolean bl2 = false;
        if (it$iv) {
            boolean bl3 = false;
            this.logDebug("setComposingRegion(" + start + ", " + end + ')');
            this.addEditCommandWithBatch(new SetComposingRegionCommand(start, end));
        }
        return bl;
    }

    public boolean setComposingText(@Nullable CharSequence text, int newCursorPosition) {
        boolean combinedActive$iv;
        boolean bl;
        StatelessInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean it$iv = bl = (combinedActive$iv = this_$iv.isICActive && this_$iv.activeSessionProvider.invoke() != null);
        boolean bl2 = false;
        if (it$iv) {
            boolean bl3 = false;
            this.logDebug("setComposingText(\"" + text + "\", " + newCursorPosition + ')');
            this.addEditCommandWithBatch(new SetComposingTextCommand(String.valueOf(text), newCursorPosition));
        }
        return bl;
    }

    public boolean deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) {
        boolean combinedActive$iv;
        boolean bl;
        StatelessInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean it$iv = bl = (combinedActive$iv = this_$iv.isICActive && this_$iv.activeSessionProvider.invoke() != null);
        boolean bl2 = false;
        if (it$iv) {
            boolean bl3 = false;
            this.logDebug("deleteSurroundingTextInCodePoints(" + beforeLength + ", " + afterLength + ')');
            this.addEditCommandWithBatch(new DeleteSurroundingTextInCodePointsCommand(beforeLength, afterLength));
            return true;
        }
        return bl;
    }

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        boolean combinedActive$iv;
        boolean bl;
        StatelessInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean it$iv = bl = (combinedActive$iv = this_$iv.isICActive && this_$iv.activeSessionProvider.invoke() != null);
        boolean bl2 = false;
        if (it$iv) {
            boolean bl3 = false;
            this.logDebug("deleteSurroundingText(" + beforeLength + ", " + afterLength + ')');
            this.addEditCommandWithBatch(new DeleteSurroundingTextCommand(beforeLength, afterLength));
            return true;
        }
        return bl;
    }

    public boolean setSelection(int start, int end) {
        boolean combinedActive$iv;
        boolean bl;
        StatelessInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean it$iv = bl = (combinedActive$iv = this_$iv.isICActive && this_$iv.activeSessionProvider.invoke() != null);
        boolean bl2 = false;
        if (it$iv) {
            boolean bl3 = false;
            this.logDebug("setSelection(" + start + ", " + end + ')');
            this.addEditCommandWithBatch(new SetSelectionCommand(start, end));
            return true;
        }
        return bl;
    }

    public boolean finishComposingText() {
        boolean combinedActive$iv;
        boolean bl;
        StatelessInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean it$iv = bl = (combinedActive$iv = this_$iv.isICActive && this_$iv.activeSessionProvider.invoke() != null);
        boolean bl2 = false;
        if (it$iv) {
            boolean bl3 = false;
            this.logDebug("finishComposingText()");
            this.addEditCommandWithBatch(FinishComposingTextCommand.INSTANCE);
            return true;
        }
        return bl;
    }

    public boolean sendKeyEvent(@NotNull KeyEvent event) {
        boolean combinedActive$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        StatelessInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean it$iv = bl = (combinedActive$iv = this_$iv.isICActive && this_$iv.activeSessionProvider.invoke() != null);
        boolean bl2 = false;
        if (it$iv) {
            boolean bl3 = false;
            this.logDebug("sendKeyEvent(" + event + ')');
            EditableTextInputSession editableTextInputSession = (EditableTextInputSession)this.activeSessionProvider.invoke();
            if (editableTextInputSession != null) {
                editableTextInputSession.sendKeyEvent(event);
            }
            return true;
        }
        return bl;
    }

    @NotNull
    public CharSequence getTextBeforeCursor(int maxChars, int flags) {
        String result2 = ((Object)this.getTextBeforeSelection(this.getValue(), maxChars)).toString();
        this.logDebug("getTextBeforeCursor(" + maxChars + ", " + flags + "): " + result2);
        return result2;
    }

    @NotNull
    public CharSequence getTextAfterCursor(int maxChars, int flags) {
        String result2 = ((Object)this.getTextAfterSelection(this.getValue(), maxChars)).toString();
        this.logDebug("getTextAfterCursor(" + maxChars + ", " + flags + "): " + result2);
        return result2;
    }

    @Nullable
    public CharSequence getSelectedText(int flags) {
        CharSequence result2 = TextRange.getCollapsed-impl((long)this.getValue().getSelectionInChars-d9O1mEE()) ? null : (CharSequence)((Object)this.getSelectedText(this.getValue())).toString();
        this.logDebug("getSelectedText(" + flags + "): " + result2);
        return result2;
    }

    public boolean requestCursorUpdates(int cursorUpdateMode) {
        boolean combinedActive$iv;
        boolean bl;
        StatelessInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean it$iv = bl = (combinedActive$iv = this_$iv.isICActive && this_$iv.activeSessionProvider.invoke() != null);
        boolean bl2 = false;
        if (it$iv) {
            boolean bl3 = false;
            this.logDebug("requestCursorUpdates(" + cursorUpdateMode + ')');
            return false;
        }
        return bl;
    }

    @NotNull
    public ExtractedText getExtractedText(@Nullable ExtractedTextRequest request, int flags) {
        this.logDebug("getExtractedText(" + request + ", " + flags + ')');
        return StatelessInputConnectionKt.access$toExtractedText(this.getValue());
    }

    public int getCursorCapsMode(int reqModes) {
        this.logDebug("getCursorCapsMode(" + reqModes + ')');
        return TextUtils.getCapsMode((CharSequence)this.getValue(), (int)TextRange.getMin-impl((long)this.getValue().getSelectionInChars-d9O1mEE()), (int)reqModes);
    }

    public boolean performContextMenuAction(int id) {
        boolean combinedActive$iv;
        boolean bl;
        StatelessInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean it$iv = bl = (combinedActive$iv = this_$iv.isICActive && this_$iv.activeSessionProvider.invoke() != null);
        boolean bl2 = false;
        if (it$iv) {
            boolean bl3 = false;
            this.logDebug("performContextMenuAction(" + id + ')');
            switch (id) {
                case 16908319: {
                    this.addEditCommandWithBatch(new SetSelectionCommand(0, this.getValue().length()));
                    break;
                }
                case 0x1020020: {
                    this.sendSynthesizedKeyEvent(277);
                    break;
                }
                case 0x1020021: {
                    this.sendSynthesizedKeyEvent(278);
                    break;
                }
                case 0x1020022: {
                    this.sendSynthesizedKeyEvent(279);
                }
            }
            return false;
        }
        return bl;
    }

    private final void sendSynthesizedKeyEvent(int code) {
        this.sendKeyEvent(new KeyEvent(0, code));
        this.sendKeyEvent(new KeyEvent(1, code));
    }

    public boolean performEditorAction(int editorAction) {
        boolean combinedActive$iv;
        boolean bl;
        StatelessInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean it$iv = bl = (combinedActive$iv = this_$iv.isICActive && this_$iv.activeSessionProvider.invoke() != null);
        boolean bl2 = false;
        if (it$iv) {
            int n;
            boolean bl3 = false;
            this.logDebug("performEditorAction(" + editorAction + ')');
            switch (editorAction) {
                case 0: {
                    n = ImeAction.Companion.getDefault-eUduSuo();
                    break;
                }
                case 6: {
                    n = ImeAction.Companion.getDone-eUduSuo();
                    break;
                }
                case 4: {
                    n = ImeAction.Companion.getSend-eUduSuo();
                    break;
                }
                case 3: {
                    n = ImeAction.Companion.getSearch-eUduSuo();
                    break;
                }
                case 7: {
                    n = ImeAction.Companion.getPrevious-eUduSuo();
                    break;
                }
                case 5: {
                    n = ImeAction.Companion.getNext-eUduSuo();
                    break;
                }
                case 2: {
                    n = ImeAction.Companion.getGo-eUduSuo();
                    break;
                }
                default: {
                    this.logDebug("IME sent an unrecognized editor action: " + editorAction);
                    n = ImeAction.Companion.getDefault-eUduSuo();
                }
            }
            int imeAction = n;
            EditableTextInputSession editableTextInputSession = (EditableTextInputSession)this.activeSessionProvider.invoke();
            if (editableTextInputSession != null) {
                editableTextInputSession.onImeAction-KlQnJC8(imeAction);
            }
            return true;
        }
        return bl;
    }

    public boolean commitCompletion(@Nullable CompletionInfo text) {
        CompletionInfo completionInfo = text;
        this.logDebug("commitCompletion(" + (completionInfo != null ? completionInfo.getText() : null) + ')');
        return false;
    }

    public boolean commitCorrection(@Nullable CorrectionInfo correctionInfo) {
        return true;
    }

    @Nullable
    public Handler getHandler() {
        this.logDebug("getHandler()");
        return null;
    }

    public boolean clearMetaKeyStates(int states) {
        this.logDebug("clearMetaKeyStates(" + states + ')');
        return false;
    }

    public boolean reportFullscreenMode(boolean enabled) {
        this.logDebug("reportFullscreenMode(" + enabled + ')');
        return false;
    }

    public boolean performPrivateCommand(@Nullable String action, @Nullable Bundle data) {
        boolean combinedActive$iv;
        boolean bl;
        StatelessInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean it$iv = bl = (combinedActive$iv = this_$iv.isICActive && this_$iv.activeSessionProvider.invoke() != null);
        boolean bl2 = false;
        if (it$iv) {
            boolean bl3 = false;
            this.logDebug("performPrivateCommand(" + action + ", " + data + ')');
            return true;
        }
        return bl;
    }

    public boolean commitContent(@NotNull InputContentInfo inputContentInfo, int flags, @Nullable Bundle opts) {
        boolean combinedActive$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)inputContentInfo, (String)"inputContentInfo");
        StatelessInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean it$iv = bl = (combinedActive$iv = this_$iv.isICActive && this_$iv.activeSessionProvider.invoke() != null);
        boolean bl2 = false;
        if (it$iv) {
            boolean bl3 = false;
            this.logDebug("commitContent(" + inputContentInfo + ", " + flags + ", " + opts + ')');
            return false;
        }
        return bl;
    }

    @NotNull
    public final CharSequence getTextBeforeSelection(@NotNull TextFieldCharSequence $this$getTextBeforeSelection, int maxChars) {
        Intrinsics.checkNotNullParameter((Object)$this$getTextBeforeSelection, (String)"<this>");
        return $this$getTextBeforeSelection.subSequence(Math.max(0, TextRange.getMin-impl((long)$this$getTextBeforeSelection.getSelectionInChars-d9O1mEE()) - maxChars), TextRange.getMin-impl((long)$this$getTextBeforeSelection.getSelectionInChars-d9O1mEE()));
    }

    @NotNull
    public final CharSequence getTextAfterSelection(@NotNull TextFieldCharSequence $this$getTextAfterSelection, int maxChars) {
        Intrinsics.checkNotNullParameter((Object)$this$getTextAfterSelection, (String)"<this>");
        return $this$getTextAfterSelection.subSequence(TextRange.getMax-impl((long)$this$getTextAfterSelection.getSelectionInChars-d9O1mEE()), Math.min(TextRange.getMax-impl((long)$this$getTextAfterSelection.getSelectionInChars-d9O1mEE()) + maxChars, $this$getTextAfterSelection.length()));
    }

    @NotNull
    public final CharSequence getSelectedText(@NotNull TextFieldCharSequence $this$getSelectedText) {
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedText, (String)"<this>");
        return $this$getSelectedText.subSequence(TextRange.getMin-impl((long)$this$getSelectedText.getSelectionInChars-d9O1mEE()), TextRange.getMax-impl((long)$this$getSelectedText.getSelectionInChars-d9O1mEE()));
    }

    private final void logDebug(String message) {
    }
}

