/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.Handle;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionManager;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RectKt;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.unit.IntSize;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a%\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a-\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u001e\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0000\u001a!\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0001H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\f\u0010\u0017\u001a\u00020\u0013*\u00020\u0018H\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"calculateSelectionMagnifierCenterAndroid", "Landroidx/compose/ui/geometry/Offset;", "manager", "Landroidx/compose/foundation/text/selection/SelectionManager;", "magnifierSize", "Landroidx/compose/ui/unit/IntSize;", "calculateSelectionMagnifierCenterAndroid-O0kMr_c", "(Landroidx/compose/foundation/text/selection/SelectionManager;J)J", "getMagnifierCenter", "anchor", "Landroidx/compose/foundation/text/selection/Selection$AnchorInfo;", "getMagnifierCenter-JVtK1S4", "(Landroidx/compose/foundation/text/selection/SelectionManager;JLandroidx/compose/foundation/text/selection/Selection$AnchorInfo;)J", "merge", "Landroidx/compose/foundation/text/selection/Selection;", "lhs", "rhs", "containsInclusive", "", "Landroidx/compose/ui/geometry/Rect;", "offset", "containsInclusive-Uv8p0NA", "(Landroidx/compose/ui/geometry/Rect;J)Z", "visibleBounds", "Landroidx/compose/ui/layout/LayoutCoordinates;", "foundation_release"})
public final class SelectionManagerKt {
    @Nullable
    public static final Selection merge(@Nullable Selection lhs, @Nullable Selection rhs) {
        Selection selection = lhs;
        if (selection == null || (selection = selection.merge(rhs)) == null) {
            selection = rhs;
        }
        return selection;
    }

    public static final long calculateSelectionMagnifierCenterAndroid-O0kMr_c(@NotNull SelectionManager manager, long magnifierSize) {
        long l;
        Selection selection = manager.getSelection();
        if (selection == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        Selection selection2 = selection;
        Handle handle = manager.getDraggingHandle();
        switch (handle == null ? -1 : WhenMappings.$EnumSwitchMapping$0[handle.ordinal()]) {
            case -1: {
                return Offset.Companion.getUnspecified-F1C5BW0();
            }
            case 1: {
                l = SelectionManagerKt.getMagnifierCenter-JVtK1S4(manager, magnifierSize, selection2.getStart());
                break;
            }
            case 2: {
                l = SelectionManagerKt.getMagnifierCenter-JVtK1S4(manager, magnifierSize, selection2.getEnd());
                break;
            }
            case 3: {
                throw new IllegalStateException("SelectionContainer does not support cursor".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return l;
    }

    private static final long getMagnifierCenter-JVtK1S4(SelectionManager manager, long magnifierSize, Selection.AnchorInfo anchor) {
        float textConstrainedX;
        float f;
        Selectable selectable2 = manager.getAnchorSelectable$foundation_release(anchor);
        if (selectable2 == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        Selectable selectable3 = selectable2;
        LayoutCoordinates layoutCoordinates = manager.getContainerLayoutCoordinates();
        if (layoutCoordinates == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        LayoutCoordinates containerCoordinates = layoutCoordinates;
        LayoutCoordinates layoutCoordinates2 = selectable3.getLayoutCoordinates();
        if (layoutCoordinates2 == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        LayoutCoordinates selectableCoordinates = layoutCoordinates2;
        int offset = anchor.getOffset();
        if (offset > selectable3.getLastVisibleOffset()) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        Offset offset2 = manager.getCurrentDragPosition-_m7T9-E();
        Intrinsics.checkNotNull((Object)offset2);
        long localDragPosition = selectableCoordinates.localPositionOf-R5De75A(containerCoordinates, offset2.unbox-impl());
        float dragX = Offset.getX-impl((long)localDragPosition);
        long lineRange = selectable3.getRangeOfLineContaining--jx7JFs(offset);
        if (TextRange.getCollapsed-impl((long)lineRange)) {
            f = selectable3.getLineLeft(offset);
        } else {
            float lineStartX = selectable3.getLineLeft(TextRange.getStart-impl((long)lineRange));
            float lineEndX = selectable3.getLineRight(TextRange.getEnd-impl((long)lineRange) - 1);
            float minX = Math.min(lineStartX, lineEndX);
            float maxX = Math.max(lineStartX, lineEndX);
            f = textConstrainedX = RangesKt.coerceIn((float)dragX, (float)minX, (float)maxX);
        }
        if (textConstrainedX == -1.0f) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        if (Math.abs(dragX - textConstrainedX) > (float)(IntSize.getWidth-impl((long)magnifierSize) / 2)) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        float lineCenterY = selectable3.getCenterYForOffset(offset);
        if (lineCenterY == -1.0f) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        return containerCoordinates.localPositionOf-R5De75A(selectableCoordinates, OffsetKt.Offset((float)textConstrainedX, (float)lineCenterY));
    }

    @NotNull
    public static final Rect visibleBounds(@NotNull LayoutCoordinates $this$visibleBounds) {
        Rect boundsInWindow = LayoutCoordinatesKt.boundsInWindow((LayoutCoordinates)$this$visibleBounds);
        return RectKt.Rect-0a9Yr6o((long)$this$visibleBounds.windowToLocal-MK-Hz9U(boundsInWindow.getTopLeft-F1C5BW0()), (long)$this$visibleBounds.windowToLocal-MK-Hz9U(boundsInWindow.getBottomRight-F1C5BW0()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean containsInclusive-Uv8p0NA(@NotNull Rect $this$containsInclusive_u2dUv8p0NA, long offset) {
        float f = $this$containsInclusive_u2dUv8p0NA.getLeft();
        float f2 = $this$containsInclusive_u2dUv8p0NA.getRight();
        float f3 = Offset.getX-impl((long)offset);
        if (!(f <= f3)) return false;
        if (!(f3 <= f2)) return false;
        boolean bl = true;
        if (!bl) return false;
        f = $this$containsInclusive_u2dUv8p0NA.getTop();
        f2 = $this$containsInclusive_u2dUv8p0NA.getBottom();
        f3 = Offset.getY-impl((long)offset);
        if (!(f <= f3)) return false;
        if (!(f3 <= f2)) return false;
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Handle.values().length];
            try {
                nArray[Handle.SelectionStart.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Handle.SelectionEnd.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Handle.Cursor.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

