/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text2.input.internal;

import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputContentInfo;
import androidx.compose.foundation.text2.input.TextFieldCharSequence;
import androidx.compose.foundation.text2.input.TextFieldCharSequenceKt;
import androidx.compose.foundation.text2.input.internal.EditCommandKt;
import androidx.compose.foundation.text2.input.internal.EditingBuffer;
import androidx.compose.foundation.text2.input.internal.StatelessInputConnection;
import androidx.compose.foundation.text2.input.internal.StatelessInputConnection_androidKt;
import androidx.compose.foundation.text2.input.internal.TextInputSession;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.input.ImeAction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0011\u001a\u00020\u000b2\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\b\fH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\b\u0010\u0018\u001a\u00020\u000bH\u0016J\u0012\u0010\u0019\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u001aH\u0016J\"\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010!\u001a\u00020\u00142\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u001a\u0010$\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u0006H\u0016J\u0018\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006H\u0016J\u0018\u0010*\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006H\u0016J\b\u0010+\u001a\u00020\u0014H\u0016J\b\u0010,\u001a\u00020\u0014H\u0002J\b\u0010-\u001a\u00020\u0014H\u0016J\u0010\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0006H\u0016J\u001a\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u0001032\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J\n\u00104\u001a\u0004\u0018\u000105H\u0016J\u0012\u00106\u001a\u0004\u0018\u00010%2\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J\u0018\u00107\u001a\u00020%2\u0006\u00108\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J\u0018\u00109\u001a\u00020%2\u0006\u00108\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J\u0010\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020\u00142\u0006\u0010>\u001a\u00020\u0006H\u0016J\u0010\u0010?\u001a\u00020\u00142\u0006\u0010@\u001a\u00020\u0006H\u0016J\u001c\u0010A\u001a\u00020\u00142\b\u0010B\u001a\u0004\u0018\u00010<2\b\u0010C\u001a\u0004\u0018\u00010 H\u0016J\u0010\u0010D\u001a\u00020\u00142\u0006\u0010E\u001a\u00020\u0014H\u0016J\u0010\u0010F\u001a\u00020\u00142\u0006\u0010G\u001a\u00020\u0006H\u0016J\u0010\u0010H\u001a\u00020\u00142\u0006\u0010I\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020\u000b2\u0006\u0010L\u001a\u00020\u0006H\u0002J\u0018\u0010M\u001a\u00020\u00142\u0006\u0010N\u001a\u00020\u00062\u0006\u0010O\u001a\u00020\u0006H\u0016J\u001a\u0010P\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u0006H\u0016J\u0018\u0010Q\u001a\u00020\u00142\u0006\u0010N\u001a\u00020\u00062\u0006\u0010O\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R%\u0010\u0007\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\b\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006R"}, d2={"Landroidx/compose/foundation/text2/input/internal/StatelessInputConnection;", "Landroid/view/inputmethod/InputConnection;", "session", "Landroidx/compose/foundation/text2/input/internal/TextInputSession;", "(Landroidx/compose/foundation/text2/input/internal/TextInputSession;)V", "batchDepth", "", "editCommands", "Landroidx/compose/runtime/collection/MutableVector;", "Lkotlin/Function1;", "Landroidx/compose/foundation/text2/input/internal/EditingBuffer;", "", "Lkotlin/ExtensionFunctionType;", "text", "Landroidx/compose/foundation/text2/input/TextFieldCharSequence;", "getText", "()Landroidx/compose/foundation/text2/input/TextFieldCharSequence;", "addEditCommandWithBatch", "editCommand", "beginBatchEdit", "", "beginBatchEditInternal", "clearMetaKeyStates", "states", "closeConnection", "commitCompletion", "Landroid/view/inputmethod/CompletionInfo;", "commitContent", "inputContentInfo", "Landroid/view/inputmethod/InputContentInfo;", "flags", "opts", "Landroid/os/Bundle;", "commitCorrection", "correctionInfo", "Landroid/view/inputmethod/CorrectionInfo;", "commitText", "", "newCursorPosition", "deleteSurroundingText", "beforeLength", "afterLength", "deleteSurroundingTextInCodePoints", "endBatchEdit", "endBatchEditInternal", "finishComposingText", "getCursorCapsMode", "reqModes", "getExtractedText", "Landroid/view/inputmethod/ExtractedText;", "request", "Landroid/view/inputmethod/ExtractedTextRequest;", "getHandler", "Landroid/os/Handler;", "getSelectedText", "getTextAfterCursor", "maxChars", "getTextBeforeCursor", "logDebug", "message", "", "performContextMenuAction", "id", "performEditorAction", "editorAction", "performPrivateCommand", "action", "data", "reportFullscreenMode", "enabled", "requestCursorUpdates", "cursorUpdateMode", "sendKeyEvent", "event", "Landroid/view/KeyEvent;", "sendSynthesizedKeyEvent", "code", "setComposingRegion", "start", "end", "setComposingText", "setSelection", "foundation_release"})
@SourceDebugExtension(value={"SMAP\nStatelessInputConnection.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatelessInputConnection.android.kt\nandroidx/compose/foundation/text2/input/internal/StatelessInputConnection\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n*L\n1#1,372:1\n1208#2:373\n1187#2,2:374\n*S KotlinDebug\n*F\n+ 1 StatelessInputConnection.android.kt\nandroidx/compose/foundation/text2/input/internal/StatelessInputConnection\n*L\n72#1:373\n72#1:374,2\n*E\n"})
public final class StatelessInputConnection
implements InputConnection {
    @NotNull
    private final TextInputSession session;
    private int batchDepth;
    @NotNull
    private final MutableVector<Function1<EditingBuffer, Unit>> editCommands;

    public StatelessInputConnection(@NotNull TextInputSession session) {
        this.session = session;
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.editCommands = new MutableVector((Object[])new Function1[capacity$iv$iv], 0);
    }

    private final TextFieldCharSequence getText() {
        return this.session.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addEditCommandWithBatch(Function1<? super EditingBuffer, Unit> editCommand) {
        this.beginBatchEditInternal();
        try {
            this.editCommands.add(editCommand);
        }
        finally {
            this.endBatchEditInternal();
        }
    }

    public boolean beginBatchEdit() {
        this.logDebug("beginBatchEdit()");
        return this.beginBatchEditInternal();
    }

    private final boolean beginBatchEditInternal() {
        int n = this.batchDepth;
        this.batchDepth = n + 1;
        return true;
    }

    public boolean endBatchEdit() {
        this.logDebug("endBatchEdit()");
        return this.endBatchEditInternal();
    }

    private final boolean endBatchEditInternal() {
        int n = this.batchDepth;
        this.batchDepth = n + -1;
        if (this.batchDepth == 0 && this.editCommands.isNotEmpty()) {
            this.session.requestEdit((Function1<? super EditingBuffer, Unit>)((Function1)new Function1<EditingBuffer, Unit>(this){
                final /* synthetic */ StatelessInputConnection this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull EditingBuffer $this$requestEdit) {
                    MutableVector this_$iv = StatelessInputConnection.access$getEditCommands$p(this.this$0);
                    boolean $i$f$forEach = false;
                    int size$iv = this_$iv.getSize();
                    if (size$iv > 0) {
                        int i$iv = 0;
                        Object[] content$iv = this_$iv.getContent();
                        do {
                            Function1 it = (Function1)content$iv[i$iv];
                            boolean bl = false;
                            it.invoke((Object)$this$requestEdit);
                        } while (++i$iv < size$iv);
                    }
                }
            }));
            this.editCommands.clear();
        }
        return this.batchDepth > 0;
    }

    public void closeConnection() {
        this.logDebug("closeConnection()");
        this.editCommands.clear();
        this.batchDepth = 0;
    }

    public boolean commitText(@Nullable CharSequence text, int newCursorPosition) {
        this.logDebug("commitText(\"" + text + "\", " + newCursorPosition + ')');
        this.addEditCommandWithBatch((Function1<? super EditingBuffer, Unit>)((Function1)new Function1<EditingBuffer, Unit>(text, newCursorPosition){
            final /* synthetic */ CharSequence $text;
            final /* synthetic */ int $newCursorPosition;
            {
                this.$text = $text;
                this.$newCursorPosition = $newCursorPosition;
                super(1);
            }

            public final void invoke(@NotNull EditingBuffer $this$addEditCommandWithBatch) {
                EditCommandKt.commitText($this$addEditCommandWithBatch, String.valueOf(this.$text), this.$newCursorPosition);
            }
        }));
        return true;
    }

    public boolean setComposingRegion(int start, int end) {
        this.logDebug("setComposingRegion(" + start + ", " + end + ')');
        this.addEditCommandWithBatch((Function1<? super EditingBuffer, Unit>)((Function1)new Function1<EditingBuffer, Unit>(start, end){
            final /* synthetic */ int $start;
            final /* synthetic */ int $end;
            {
                this.$start = $start;
                this.$end = $end;
                super(1);
            }

            public final void invoke(@NotNull EditingBuffer $this$addEditCommandWithBatch) {
                EditCommandKt.setComposingRegion($this$addEditCommandWithBatch, this.$start, this.$end);
            }
        }));
        return true;
    }

    public boolean setComposingText(@Nullable CharSequence text, int newCursorPosition) {
        this.logDebug("setComposingText(\"" + text + "\", " + newCursorPosition + ')');
        this.addEditCommandWithBatch((Function1<? super EditingBuffer, Unit>)((Function1)new Function1<EditingBuffer, Unit>(text, newCursorPosition){
            final /* synthetic */ CharSequence $text;
            final /* synthetic */ int $newCursorPosition;
            {
                this.$text = $text;
                this.$newCursorPosition = $newCursorPosition;
                super(1);
            }

            public final void invoke(@NotNull EditingBuffer $this$addEditCommandWithBatch) {
                EditCommandKt.setComposingText($this$addEditCommandWithBatch, String.valueOf(this.$text), this.$newCursorPosition);
            }
        }));
        return true;
    }

    public boolean deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) {
        this.logDebug("deleteSurroundingTextInCodePoints(" + beforeLength + ", " + afterLength + ')');
        this.addEditCommandWithBatch((Function1<? super EditingBuffer, Unit>)((Function1)new Function1<EditingBuffer, Unit>(beforeLength, afterLength){
            final /* synthetic */ int $beforeLength;
            final /* synthetic */ int $afterLength;
            {
                this.$beforeLength = $beforeLength;
                this.$afterLength = $afterLength;
                super(1);
            }

            public final void invoke(@NotNull EditingBuffer $this$addEditCommandWithBatch) {
                EditCommandKt.deleteSurroundingTextInCodePoints($this$addEditCommandWithBatch, this.$beforeLength, this.$afterLength);
            }
        }));
        return true;
    }

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        this.logDebug("deleteSurroundingText(" + beforeLength + ", " + afterLength + ')');
        this.addEditCommandWithBatch((Function1<? super EditingBuffer, Unit>)((Function1)new Function1<EditingBuffer, Unit>(beforeLength, afterLength){
            final /* synthetic */ int $beforeLength;
            final /* synthetic */ int $afterLength;
            {
                this.$beforeLength = $beforeLength;
                this.$afterLength = $afterLength;
                super(1);
            }

            public final void invoke(@NotNull EditingBuffer $this$addEditCommandWithBatch) {
                EditCommandKt.deleteSurroundingText($this$addEditCommandWithBatch, this.$beforeLength, this.$afterLength);
            }
        }));
        return true;
    }

    public boolean setSelection(int start, int end) {
        this.logDebug("setSelection(" + start + ", " + end + ')');
        this.addEditCommandWithBatch((Function1<? super EditingBuffer, Unit>)((Function1)new Function1<EditingBuffer, Unit>(start, end){
            final /* synthetic */ int $start;
            final /* synthetic */ int $end;
            {
                this.$start = $start;
                this.$end = $end;
                super(1);
            }

            public final void invoke(@NotNull EditingBuffer $this$addEditCommandWithBatch) {
                $this$addEditCommandWithBatch.setSelection(this.$start, this.$end);
            }
        }));
        return true;
    }

    public boolean finishComposingText() {
        this.logDebug("finishComposingText()");
        this.addEditCommandWithBatch((Function1<? super EditingBuffer, Unit>)((Function1)finishComposingText.1.INSTANCE));
        return true;
    }

    public boolean sendKeyEvent(@NotNull KeyEvent event) {
        this.logDebug("sendKeyEvent(" + event + ')');
        this.session.sendKeyEvent(event);
        return true;
    }

    @NotNull
    public CharSequence getTextBeforeCursor(int maxChars, int flags) {
        String result2 = ((Object)TextFieldCharSequenceKt.getTextBeforeSelection(this.getText(), maxChars)).toString();
        this.logDebug("getTextBeforeCursor(" + maxChars + ", " + flags + "): " + result2);
        return result2;
    }

    @NotNull
    public CharSequence getTextAfterCursor(int maxChars, int flags) {
        String result2 = ((Object)TextFieldCharSequenceKt.getTextAfterSelection(this.getText(), maxChars)).toString();
        this.logDebug("getTextAfterCursor(" + maxChars + ", " + flags + "): " + result2);
        return result2;
    }

    @Nullable
    public CharSequence getSelectedText(int flags) {
        CharSequence result2 = TextRange.getCollapsed-impl((long)this.getText().getSelectionInChars-d9O1mEE()) ? null : (CharSequence)((Object)TextFieldCharSequenceKt.getSelectedText(this.getText())).toString();
        this.logDebug("getSelectedText(" + flags + "): " + result2);
        return result2;
    }

    public boolean requestCursorUpdates(int cursorUpdateMode) {
        this.logDebug("requestCursorUpdates(" + cursorUpdateMode + ')');
        return false;
    }

    @NotNull
    public ExtractedText getExtractedText(@Nullable ExtractedTextRequest request, int flags) {
        this.logDebug("getExtractedText(" + request + ", " + flags + ')');
        return StatelessInputConnection_androidKt.access$toExtractedText(this.getText());
    }

    public int getCursorCapsMode(int reqModes) {
        this.logDebug("getCursorCapsMode(" + reqModes + ')');
        return TextUtils.getCapsMode((CharSequence)this.getText(), (int)TextRange.getMin-impl((long)this.getText().getSelectionInChars-d9O1mEE()), (int)reqModes);
    }

    public boolean performContextMenuAction(int id) {
        this.logDebug("performContextMenuAction(" + id + ')');
        switch (id) {
            case 16908319: {
                this.addEditCommandWithBatch((Function1<? super EditingBuffer, Unit>)((Function1)new Function1<EditingBuffer, Unit>(this){
                    final /* synthetic */ StatelessInputConnection this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull EditingBuffer $this$addEditCommandWithBatch) {
                        $this$addEditCommandWithBatch.setSelection(0, StatelessInputConnection.access$getText(this.this$0).length());
                    }
                }));
                break;
            }
            case 0x1020020: {
                this.sendSynthesizedKeyEvent(277);
                break;
            }
            case 0x1020021: {
                this.sendSynthesizedKeyEvent(278);
                break;
            }
            case 0x1020022: {
                this.sendSynthesizedKeyEvent(279);
            }
        }
        return false;
    }

    private final void sendSynthesizedKeyEvent(int code) {
        this.sendKeyEvent(new KeyEvent(0, code));
        this.sendKeyEvent(new KeyEvent(1, code));
    }

    public boolean performEditorAction(int editorAction) {
        int n;
        this.logDebug("performEditorAction(" + editorAction + ')');
        switch (editorAction) {
            case 0: {
                n = ImeAction.Companion.getDefault-eUduSuo();
                break;
            }
            case 6: {
                n = ImeAction.Companion.getDone-eUduSuo();
                break;
            }
            case 4: {
                n = ImeAction.Companion.getSend-eUduSuo();
                break;
            }
            case 3: {
                n = ImeAction.Companion.getSearch-eUduSuo();
                break;
            }
            case 7: {
                n = ImeAction.Companion.getPrevious-eUduSuo();
                break;
            }
            case 5: {
                n = ImeAction.Companion.getNext-eUduSuo();
                break;
            }
            case 2: {
                n = ImeAction.Companion.getGo-eUduSuo();
                break;
            }
            default: {
                this.logDebug("IME sent an unrecognized editor action: " + editorAction);
                n = ImeAction.Companion.getDefault-eUduSuo();
            }
        }
        int imeAction = n;
        this.session.onImeAction-KlQnJC8(imeAction);
        return true;
    }

    public boolean commitCompletion(@Nullable CompletionInfo text) {
        CompletionInfo completionInfo = text;
        this.logDebug("commitCompletion(" + (completionInfo != null ? completionInfo.getText() : null) + ')');
        return false;
    }

    public boolean commitCorrection(@Nullable CorrectionInfo correctionInfo) {
        return true;
    }

    @Nullable
    public Handler getHandler() {
        this.logDebug("getHandler()");
        return null;
    }

    public boolean clearMetaKeyStates(int states) {
        this.logDebug("clearMetaKeyStates(" + states + ')');
        return false;
    }

    public boolean reportFullscreenMode(boolean enabled) {
        this.logDebug("reportFullscreenMode(" + enabled + ')');
        return false;
    }

    public boolean performPrivateCommand(@Nullable String action, @Nullable Bundle data) {
        this.logDebug("performPrivateCommand(" + action + ", " + data + ')');
        return true;
    }

    public boolean commitContent(@NotNull InputContentInfo inputContentInfo, int flags, @Nullable Bundle opts) {
        this.logDebug("commitContent(" + inputContentInfo + ", " + flags + ", " + opts + ')');
        return false;
    }

    private final void logDebug(String message) {
    }

    public static final /* synthetic */ MutableVector access$getEditCommands$p(StatelessInputConnection $this) {
        return $this.editCommands;
    }

    public static final /* synthetic */ TextFieldCharSequence access$getText(StatelessInputConnection $this) {
        return $this.getText();
    }
}

