/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation;

import android.graphics.Rect;
import android.view.View;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.node.CompositionLocalConsumerModifierNode;
import androidx.compose.ui.node.CompositionLocalConsumerModifierNodeKt;
import androidx.compose.ui.node.GlobalPositionAwareModifierNode;
import androidx.compose.ui.platform.AndroidCompositionLocals_androidKt;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b \u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001b\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0007H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015H&J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0012\u0010\u001a\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\nH\u0002J\u0016\u0010\u001c\u001a\u00020\u00172\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u0015H&R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\bR\u0014\u0010\u000e\u001a\u00020\u000f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Landroidx/compose/foundation/RectListNode;", "Landroidx/compose/ui/Modifier$Node;", "Landroidx/compose/ui/node/GlobalPositionAwareModifierNode;", "Landroidx/compose/ui/node/CompositionLocalConsumerModifierNode;", "rect", "Lkotlin/Function1;", "Landroidx/compose/ui/layout/LayoutCoordinates;", "Landroidx/compose/ui/geometry/Rect;", "(Lkotlin/jvm/functions/Function1;)V", "androidRect", "Landroid/graphics/Rect;", "getRect", "()Lkotlin/jvm/functions/Function1;", "setRect", "view", "Landroid/view/View;", "getView", "()Landroid/view/View;", "calcBounds", "layoutCoordinates", "currentRects", "Landroidx/compose/runtime/collection/MutableVector;", "onDetach", "", "onGloballyPositioned", "coordinates", "replaceRect", "newRect", "updateRects", "rects", "foundation_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRectListNode.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RectListNode.android.kt\nandroidx/compose/foundation/RectListNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,99:1\n1#2:100\n728#3,2:101\n*S KotlinDebug\n*F\n+ 1 RectListNode.android.kt\nandroidx/compose/foundation/RectListNode\n*L\n69#1:101,2\n*E\n"})
public abstract class RectListNode
extends Modifier.Node
implements GlobalPositionAwareModifierNode,
CompositionLocalConsumerModifierNode {
    @Nullable
    private Function1<? super LayoutCoordinates, androidx.compose.ui.geometry.Rect> rect;
    @Nullable
    private Rect androidRect;
    public static final int $stable = 8;

    public RectListNode(@Nullable Function1<? super LayoutCoordinates, androidx.compose.ui.geometry.Rect> rect) {
        this.rect = rect;
    }

    @Nullable
    public Function1<LayoutCoordinates, androidx.compose.ui.geometry.Rect> getRect() {
        return this.rect;
    }

    public void setRect(@Nullable Function1<? super LayoutCoordinates, androidx.compose.ui.geometry.Rect> function1) {
        this.rect = function1;
    }

    @NotNull
    protected final View getView() {
        return (View)CompositionLocalConsumerModifierNodeKt.currentValueOf((CompositionLocalConsumerModifierNode)this, (CompositionLocal)((CompositionLocal)AndroidCompositionLocals_androidKt.getLocalView()));
    }

    public void onGloballyPositioned(@NotNull LayoutCoordinates coordinates) {
        Rect rect;
        if (this.getRect() == null) {
            androidx.compose.ui.geometry.Rect boundsInRoot = LayoutCoordinatesKt.boundsInRoot((LayoutCoordinates)coordinates);
            rect = new Rect(MathKt.roundToInt((float)boundsInRoot.getLeft()), MathKt.roundToInt((float)boundsInRoot.getTop()), MathKt.roundToInt((float)boundsInRoot.getRight()), MathKt.roundToInt((float)boundsInRoot.getBottom()));
        } else {
            Function1<LayoutCoordinates, androidx.compose.ui.geometry.Rect> function1 = this.getRect();
            Intrinsics.checkNotNull(function1);
            rect = this.calcBounds(coordinates, (androidx.compose.ui.geometry.Rect)function1.invoke((Object)coordinates));
        }
        Rect newRect = rect;
        this.replaceRect(newRect);
    }

    public void onDetach() {
        super.onDetach();
        this.replaceRect(null);
    }

    @NotNull
    public abstract MutableVector<Rect> currentRects();

    public abstract void updateRects(@NotNull MutableVector<Rect> var1);

    private final void replaceRect(Rect newRect) {
        MutableVector<Rect> rects = this.currentRects();
        Rect rect = this.androidRect;
        if (rect != null) {
            Rect it = rect;
            boolean bl = false;
            rects.remove((Object)it);
        }
        Rect rect2 = newRect;
        boolean bl = rect2 != null ? !rect2.isEmpty() : false;
        if (bl) {
            MutableVector<Rect> this_$iv = rects;
            boolean $i$f$plusAssign = false;
            this_$iv.add((Object)newRect);
        }
        this.updateRects(rects);
        this.androidRect = newRect;
    }

    private final Rect calcBounds(LayoutCoordinates layoutCoordinates, androidx.compose.ui.geometry.Rect rect) {
        LayoutCoordinates root = LayoutCoordinatesKt.findRootCoordinates((LayoutCoordinates)layoutCoordinates);
        long topLeft = root.localPositionOf-R5De75A(layoutCoordinates, rect.getTopLeft-F1C5BW0());
        long topRight = root.localPositionOf-R5De75A(layoutCoordinates, rect.getTopRight-F1C5BW0());
        long bottomLeft = root.localPositionOf-R5De75A(layoutCoordinates, rect.getBottomLeft-F1C5BW0());
        long bottomRight = root.localPositionOf-R5De75A(layoutCoordinates, rect.getBottomRight-F1C5BW0());
        float[] fArray = new float[]{Offset.getX-impl((long)topRight), Offset.getX-impl((long)bottomLeft), Offset.getX-impl((long)bottomRight)};
        float left = ComparisonsKt.minOf((float)Offset.getX-impl((long)topLeft), (float[])fArray);
        float[] fArray2 = new float[]{Offset.getY-impl((long)topRight), Offset.getY-impl((long)bottomLeft), Offset.getY-impl((long)bottomRight)};
        float top = ComparisonsKt.minOf((float)Offset.getY-impl((long)topLeft), (float[])fArray2);
        float[] fArray3 = new float[]{Offset.getX-impl((long)topRight), Offset.getX-impl((long)bottomLeft), Offset.getX-impl((long)bottomRight)};
        float right = ComparisonsKt.maxOf((float)Offset.getX-impl((long)topLeft), (float[])fArray3);
        float[] fArray4 = new float[]{Offset.getY-impl((long)topRight), Offset.getY-impl((long)bottomLeft), Offset.getY-impl((long)bottomRight)};
        float bottom = ComparisonsKt.maxOf((float)Offset.getY-impl((long)topLeft), (float[])fArray4);
        return new Rect(MathKt.roundToInt((float)left), MathKt.roundToInt((float)top), MathKt.roundToInt((float)right), MathKt.roundToInt((float)bottom));
    }
}

