/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.layout;

import android.os.Trace;
import android.view.Choreographer;
import android.view.Display;
import android.view.View;
import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.lazy.layout.PrefetchExecutor;
import androidx.compose.runtime.RememberObserver;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\r\b\u0001\u0018\u0000 $2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001$B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0016J \u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\b\u0010\u001e\u001a\u00020\u0018H\u0016J\b\u0010\u001f\u001a\u00020\u0018H\u0016J\b\u0010 \u001a\u00020\u0018H\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0012H\u0016J\b\u0010#\u001a\u00020\u0018H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Landroidx/compose/foundation/lazy/layout/AndroidPrefetchExecutor;", "Landroidx/compose/foundation/lazy/layout/PrefetchExecutor;", "Landroidx/compose/runtime/RememberObserver;", "Ljava/lang/Runnable;", "Landroid/view/Choreographer$FrameCallback;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "averagePrecomposeTimeNs", "", "averagePremeasureTimeNs", "choreographer", "Landroid/view/Choreographer;", "kotlin.jvm.PlatformType", "isActive", "", "prefetchRequests", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/foundation/lazy/layout/PrefetchExecutor$Request;", "prefetchScheduled", "calculateAverageTime", "new", "current", "doFrame", "", "frameTimeNanos", "enoughTimeLeft", "now", "nextFrame", "average", "onAbandoned", "onForgotten", "onRemembered", "requestPrefetch", "request", "run", "Companion", "foundation_release"})
@ExperimentalFoundationApi
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPrefetchExecutor.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrefetchExecutor.android.kt\nandroidx/compose/foundation/lazy/layout/AndroidPrefetchExecutor\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 4 AndroidTrace.android.kt\nandroidx/compose/ui/util/AndroidTrace_androidKt\n*L\n1#1,268:1\n1208#2:269\n1187#2,2:270\n523#3:272\n26#4,5:273\n26#4,5:278\n*S KotlinDebug\n*F\n+ 1 PrefetchExecutor.android.kt\nandroidx/compose/foundation/lazy/layout/AndroidPrefetchExecutor\n*L\n104#1:269\n104#1:270,2\n142#1:272\n155#1:273,5\n173#1:278,5\n*E\n"})
public final class AndroidPrefetchExecutor
implements PrefetchExecutor,
RememberObserver,
Runnable,
Choreographer.FrameCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final View view;
    @NotNull
    private final MutableVector<PrefetchExecutor.Request> prefetchRequests;
    private long averagePrecomposeTimeNs;
    private long averagePremeasureTimeNs;
    private boolean prefetchScheduled;
    private final Choreographer choreographer;
    private boolean isActive;
    public static final int $stable = 8;
    private static long frameIntervalNs;

    public AndroidPrefetchExecutor(@NotNull View view) {
        this.view = view;
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.prefetchRequests = new MutableVector((Object[])new PrefetchExecutor.Request[capacity$iv$iv], 0);
        this.choreographer = Choreographer.getInstance();
        AndroidPrefetchExecutor.Companion.calculateFrameIntervalIfNeeded(this.view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        if (this.prefetchRequests.isEmpty() || !this.prefetchScheduled || !this.isActive || this.view.getWindowVisibility() != 0) {
            this.prefetchScheduled = false;
            return;
        }
        long latestFrameVsyncNs = TimeUnit.MILLISECONDS.toNanos(this.view.getDrawingTime());
        long nextFrameNs = latestFrameVsyncNs + frameIntervalNs;
        boolean oneOverTimeTaskAllowed = false;
        oneOverTimeTaskAllowed = System.nanoTime() > nextFrameNs;
        boolean scheduleForNextFrame = false;
        while (this.prefetchRequests.isNotEmpty() && !scheduleForNextFrame) {
            Object object;
            boolean $i$f$trace;
            void this_$iv;
            MutableVector<PrefetchExecutor.Request> mutableVector = this.prefetchRequests;
            int index$iv = 0;
            boolean $i$f$get = false;
            PrefetchExecutor.Request request2 = (PrefetchExecutor.Request)this_$iv.getContent()[index$iv];
            if (!request2.isValid()) {
                this.prefetchRequests.removeAt(0);
                continue;
            }
            if (!request2.isComposed()) {
                long beforeTimeNs = System.nanoTime();
                if (this.enoughTimeLeft(beforeTimeNs, nextFrameNs, this.averagePrecomposeTimeNs) || oneOverTimeTaskAllowed) {
                    String sectionName$iv = "compose:lazylist:prefetch:compose";
                    $i$f$trace = false;
                    Trace.beginSection((String)sectionName$iv);
                    try {
                        boolean bl = false;
                        oneOverTimeTaskAllowed = false;
                        request2.performComposition();
                        this.averagePrecomposeTimeNs = this.calculateAverageTime(System.nanoTime() - beforeTimeNs, this.averagePrecomposeTimeNs);
                        object = Unit.INSTANCE;
                        continue;
                    }
                    finally {
                        Trace.endSection();
                        continue;
                    }
                }
                scheduleForNextFrame = true;
                continue;
            }
            long beforeTimeNs = System.nanoTime();
            if (this.enoughTimeLeft(beforeTimeNs, nextFrameNs, this.averagePremeasureTimeNs) || oneOverTimeTaskAllowed) {
                String sectionName$iv = "compose:lazylist:prefetch:measure";
                $i$f$trace = false;
                Trace.beginSection((String)sectionName$iv);
                try {
                    boolean bl = false;
                    oneOverTimeTaskAllowed = false;
                    request2.performMeasure();
                    this.averagePremeasureTimeNs = this.calculateAverageTime(System.nanoTime() - beforeTimeNs, this.averagePremeasureTimeNs);
                    object = (PrefetchExecutor.Request)this.prefetchRequests.removeAt(0);
                    continue;
                }
                finally {
                    Trace.endSection();
                    continue;
                }
            }
            scheduleForNextFrame = true;
        }
        if (scheduleForNextFrame) {
            this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
        } else {
            this.prefetchScheduled = false;
        }
    }

    private final boolean enoughTimeLeft(long now, long nextFrame, long average) {
        return now + average < nextFrame;
    }

    public void doFrame(long frameTimeNanos) {
        if (this.isActive) {
            this.view.post((Runnable)this);
        }
    }

    private final long calculateAverageTime(long l, long current) {
        return current == 0L ? l : current / (long)4 * (long)3 + l / (long)4;
    }

    @Override
    public void requestPrefetch(@NotNull PrefetchExecutor.Request request2) {
        this.prefetchRequests.add((Object)request2);
        if (!this.prefetchScheduled) {
            this.prefetchScheduled = true;
            this.view.post((Runnable)this);
        }
    }

    public void onRemembered() {
        this.isActive = true;
    }

    public void onForgotten() {
        this.isActive = false;
        this.view.removeCallbacks((Runnable)this);
        this.choreographer.removeFrameCallback((Choreographer.FrameCallback)this);
    }

    public void onAbandoned() {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/compose/foundation/lazy/layout/AndroidPrefetchExecutor$Companion;", "", "()V", "frameIntervalNs", "", "calculateFrameIntervalIfNeeded", "", "view", "Landroid/view/View;", "foundation_release"})
    public static final class Companion {
        private Companion() {
        }

        private final void calculateFrameIntervalIfNeeded(View view) {
            if (frameIntervalNs == 0L) {
                float displayRefreshRate;
                Display display = view.getDisplay();
                float refreshRate = 60.0f;
                if (!view.isInEditMode() && display != null && (displayRefreshRate = display.getRefreshRate()) >= 30.0f) {
                    refreshRate = displayRefreshRate;
                }
                frameIntervalNs = (long)((float)1000000000 / refreshRate);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

