/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import android.os.Build;
import android.view.View;
import androidx.compose.foundation.layout.WindowInsetsHolder;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.WindowInsetsAnimationCompat;
import androidx.core.view.WindowInsetsCompat;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0014H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001e\u0010\"\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00142\f\u0010#\u001a\b\u0012\u0004\u0012\u00020 0$H\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010'\u001a\u00020&H\u0016J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u001bH\u0016J\b\u0010+\u001a\u00020\u001eH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006,"}, d2={"Landroidx/compose/foundation/layout/InsetsListener;", "Landroidx/core/view/WindowInsetsAnimationCompat$Callback;", "Ljava/lang/Runnable;", "Landroidx/core/view/OnApplyWindowInsetsListener;", "Landroid/view/View$OnAttachStateChangeListener;", "composeInsets", "Landroidx/compose/foundation/layout/WindowInsetsHolder;", "(Landroidx/compose/foundation/layout/WindowInsetsHolder;)V", "getComposeInsets", "()Landroidx/compose/foundation/layout/WindowInsetsHolder;", "prepared", "", "getPrepared", "()Z", "setPrepared", "(Z)V", "runningAnimation", "getRunningAnimation", "setRunningAnimation", "savedInsets", "Landroidx/core/view/WindowInsetsCompat;", "getSavedInsets", "()Landroidx/core/view/WindowInsetsCompat;", "setSavedInsets", "(Landroidx/core/view/WindowInsetsCompat;)V", "onApplyWindowInsets", "view", "Landroid/view/View;", "insets", "onEnd", "", "animation", "Landroidx/core/view/WindowInsetsAnimationCompat;", "onPrepare", "onProgress", "runningAnimations", "", "onStart", "Landroidx/core/view/WindowInsetsAnimationCompat$BoundsCompat;", "bounds", "onViewAttachedToWindow", "onViewDetachedFromWindow", "v", "run", "foundation-layout_release"})
final class InsetsListener
extends WindowInsetsAnimationCompat.Callback
implements Runnable,
OnApplyWindowInsetsListener,
View.OnAttachStateChangeListener {
    @NotNull
    private final WindowInsetsHolder composeInsets;
    private boolean prepared;
    private boolean runningAnimation;
    @Nullable
    private WindowInsetsCompat savedInsets;

    public InsetsListener(@NotNull WindowInsetsHolder composeInsets) {
        Intrinsics.checkNotNullParameter((Object)composeInsets, (String)"composeInsets");
        super(composeInsets.getConsumes() ? 0 : 1);
        this.composeInsets = composeInsets;
    }

    @NotNull
    public final WindowInsetsHolder getComposeInsets() {
        return this.composeInsets;
    }

    public final boolean getPrepared() {
        return this.prepared;
    }

    public final void setPrepared(boolean bl) {
        this.prepared = bl;
    }

    public final boolean getRunningAnimation() {
        return this.runningAnimation;
    }

    public final void setRunningAnimation(boolean bl) {
        this.runningAnimation = bl;
    }

    @Nullable
    public final WindowInsetsCompat getSavedInsets() {
        return this.savedInsets;
    }

    public final void setSavedInsets(@Nullable WindowInsetsCompat windowInsetsCompat) {
        this.savedInsets = windowInsetsCompat;
    }

    public void onPrepare(@NotNull WindowInsetsAnimationCompat animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        this.prepared = true;
        this.runningAnimation = true;
        super.onPrepare(animation);
    }

    @NotNull
    public WindowInsetsAnimationCompat.BoundsCompat onStart(@NotNull WindowInsetsAnimationCompat animation, @NotNull WindowInsetsAnimationCompat.BoundsCompat bounds) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.prepared = false;
        WindowInsetsAnimationCompat.BoundsCompat boundsCompat = super.onStart(animation, bounds);
        Intrinsics.checkNotNullExpressionValue((Object)boundsCompat, (String)"super.onStart(animation, bounds)");
        return boundsCompat;
    }

    @NotNull
    public WindowInsetsCompat onProgress(@NotNull WindowInsetsCompat insets, @NotNull List<WindowInsetsAnimationCompat> runningAnimations) {
        WindowInsetsCompat windowInsetsCompat;
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        Intrinsics.checkNotNullParameter(runningAnimations, (String)"runningAnimations");
        WindowInsetsHolder.update$default(this.composeInsets, insets, 0, 2, null);
        if (this.composeInsets.getConsumes()) {
            WindowInsetsCompat windowInsetsCompat2 = WindowInsetsCompat.CONSUMED;
            windowInsetsCompat = windowInsetsCompat2;
            Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat2, (String)"CONSUMED");
        } else {
            windowInsetsCompat = insets;
        }
        return windowInsetsCompat;
    }

    public void onEnd(@NotNull WindowInsetsAnimationCompat animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        this.prepared = false;
        this.runningAnimation = false;
        WindowInsetsCompat insets = this.savedInsets;
        if (animation.getDurationMillis() != 0L && insets != null) {
            this.composeInsets.updateImeAnimationSource(insets);
            this.composeInsets.updateImeAnimationTarget(insets);
            WindowInsetsHolder.update$default(this.composeInsets, insets, 0, 2, null);
        }
        this.savedInsets = null;
        super.onEnd(animation);
    }

    @NotNull
    public WindowInsetsCompat onApplyWindowInsets(@NotNull View view, @NotNull WindowInsetsCompat insets) {
        WindowInsetsCompat windowInsetsCompat;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        this.savedInsets = insets;
        this.composeInsets.updateImeAnimationTarget(insets);
        if (this.prepared) {
            if (Build.VERSION.SDK_INT == 30) {
                view.post((Runnable)this);
            }
        } else if (!this.runningAnimation) {
            this.composeInsets.updateImeAnimationSource(insets);
            WindowInsetsHolder.update$default(this.composeInsets, insets, 0, 2, null);
        }
        if (this.composeInsets.getConsumes()) {
            WindowInsetsCompat windowInsetsCompat2 = WindowInsetsCompat.CONSUMED;
            windowInsetsCompat = windowInsetsCompat2;
            Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat2, (String)"CONSUMED");
        } else {
            windowInsetsCompat = insets;
        }
        return windowInsetsCompat;
    }

    @Override
    public void run() {
        block1: {
            if (!this.prepared) break block1;
            this.prepared = false;
            this.runningAnimation = false;
            WindowInsetsCompat windowInsetsCompat = this.savedInsets;
            if (windowInsetsCompat != null) {
                WindowInsetsCompat it = windowInsetsCompat;
                boolean bl = false;
                this.composeInsets.updateImeAnimationSource(it);
                WindowInsetsHolder.update$default(this.composeInsets, it, 0, 2, null);
                this.savedInsets = null;
            }
        }
    }

    public void onViewAttachedToWindow(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.requestApplyInsets();
    }

    public void onViewDetachedFromWindow(@NotNull View v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
    }
}

