/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.selection.SelectionMode;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, xi=16, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000f\u001aL\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001ad\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a4\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0007H\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"ensureAtLeastOneChar", "Landroidx/compose/ui/text/TextRange;", "offset", "", "lastOffset", "previousSelection", "isStartHandle", "", "handlesCrossed", "getSelectionHandleCoordinates", "Landroidx/compose/ui/geometry/Offset;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "isStart", "areHandlesCrossed", "(Landroidx/compose/ui/text/TextLayoutResult;IZZ)J", "processAsSingleComposable", "Lkotlin/Triple;", "rawStartOffset", "rawEndOffset", "processCrossComposable", "startPosition", "endPosition", "bounds", "Landroidx/compose/ui/geometry/Rect;", "containsWholeSelectionStart", "containsWholeSelectionEnd", "processCrossComposable-pltxxdk", "(JJIIILandroidx/compose/ui/geometry/Rect;ZZ)Lkotlin/Triple;", "updateWordBasedSelection", "Lkotlin/Pair;", "startOffset", "endOffset", "foundation-text_release"})
public final class TextSelectionDelegateKt {
    @NotNull
    public static final Triple<Integer, Integer, Boolean> processAsSingleComposable(int rawStartOffset, int rawEndOffset, @Nullable TextRange previousSelection, boolean isStartHandle, int lastOffset, boolean handlesCrossed) {
        int startOffset = rawStartOffset;
        int endOffset = rawEndOffset;
        if (startOffset == endOffset) {
            TextRange textRange = TextSelectionDelegateKt.ensureAtLeastOneChar(rawStartOffset, lastOffset, previousSelection, isStartHandle, handlesCrossed);
            startOffset = textRange.getStart();
            endOffset = textRange.getEnd();
        }
        boolean areHandlesCrossed = startOffset > endOffset;
        return new Triple((Object)startOffset, (Object)endOffset, (Object)areHandlesCrossed);
    }

    @NotNull
    public static final Triple<Integer, Integer, Boolean> processCrossComposable-pltxxdk(long startPosition, long endPosition, int rawStartOffset, int rawEndOffset, int lastOffset, @NotNull Rect bounds, boolean containsWholeSelectionStart, boolean containsWholeSelectionEnd) {
        int n;
        int startOffset;
        int n2;
        int n3;
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        boolean handlesCrossed = SelectionMode.Vertical.areHandlesCrossed-cYDtEUQ$foundation_text_release(bounds, startPosition, endPosition);
        boolean isSelected = SelectionMode.Vertical.isSelected-cYDtEUQ$foundation_text_release(bounds, handlesCrossed ? endPosition : startPosition, handlesCrossed ? startPosition : endPosition);
        if (isSelected && !containsWholeSelectionStart) {
            if (handlesCrossed) {
                int n4 = 0;
                n3 = 0;
                n2 = Math.max(lastOffset, n4);
            } else {
                n2 = 0;
            }
        } else {
            n2 = startOffset = rawStartOffset;
        }
        if (isSelected && !containsWholeSelectionEnd) {
            if (handlesCrossed) {
                n = 0;
            } else {
                n3 = 0;
                boolean bl = false;
                n = Math.max(lastOffset, n3);
            }
        } else {
            n = rawEndOffset;
        }
        int endOffset = n;
        return new Triple((Object)startOffset, (Object)endOffset, (Object)handlesCrossed);
    }

    @NotNull
    public static final Pair<Integer, Integer> updateWordBasedSelection(@NotNull TextLayoutResult textLayoutResult, int startOffset, int endOffset, boolean handlesCrossed) {
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        int maxOffset = textLayoutResult.getLayoutInput().getText().getText().length() - 1;
        TextRange startWordBoundary = textLayoutResult.getWordBoundary(RangesKt.coerceIn((int)startOffset, (int)0, (int)maxOffset));
        TextRange endWordBoundary = textLayoutResult.getWordBoundary(RangesKt.coerceIn((int)endOffset, (int)0, (int)maxOffset));
        int start = handlesCrossed ? startWordBoundary.getEnd() : startWordBoundary.getStart();
        int end = handlesCrossed ? endWordBoundary.getStart() : endWordBoundary.getEnd();
        return new Pair((Object)start, (Object)end);
    }

    private static final TextRange ensureAtLeastOneChar(int offset, int lastOffset, TextRange previousSelection, boolean isStartHandle, boolean handlesCrossed) {
        int newStartOffset = 0;
        newStartOffset = offset;
        int newEndOffset = 0;
        newEndOffset = offset;
        TextRange textRange = previousSelection;
        if (textRange != null) {
            TextRange textRange2 = textRange;
            boolean bl = false;
            boolean bl2 = false;
            TextRange it = textRange2;
            boolean bl3 = false;
            if (isStartHandle) {
                newStartOffset = handlesCrossed ? (newEndOffset == 0 || it.getStart() == newEndOffset + 1 ? newEndOffset + 1 : newEndOffset - 1) : (newEndOffset == lastOffset || it.getStart() == newEndOffset - 1 ? newEndOffset - 1 : newEndOffset + 1);
            } else {
                newEndOffset = handlesCrossed ? (newStartOffset == lastOffset || it.getEnd() == newStartOffset - 1 ? newStartOffset - 1 : newStartOffset + 1) : (newStartOffset == 0 || it.getEnd() == newStartOffset + 1 ? newStartOffset + 1 : newStartOffset - 1);
            }
        }
        return new TextRange(newStartOffset, newEndOffset);
    }

    public static final long getSelectionHandleCoordinates(@NotNull TextLayoutResult textLayoutResult, int offset, boolean isStart, boolean areHandlesCrossed) {
        int n;
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        int line = textLayoutResult.getLineForOffset(offset);
        if (isStart && !areHandlesCrossed || !isStart && areHandlesCrossed) {
            n = offset;
        } else {
            int n2 = offset - 1;
            int n3 = 0;
            boolean bl = false;
            n = Math.max(n2, n3);
        }
        int offsetToCheck = n;
        ResolvedTextDirection bidiRunDirection = textLayoutResult.getBidiRunDirection(offsetToCheck);
        ResolvedTextDirection paragraphDirection = textLayoutResult.getParagraphDirection(offset);
        float x = textLayoutResult.getHorizontalPosition(offset, bidiRunDirection == paragraphDirection);
        float y = textLayoutResult.getLineBottom(line);
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        float f = x;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits(f);
        float f2 = y;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        return Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
    }
}

