/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.AccessibilityNew: ImageVector
    get() {
        if (_accessibilityNew != null) {
            return _accessibilityNew!!
        }
        _accessibilityNew = materialIcon(name = "Filled.AccessibilityNew") {
            materialPath {
                moveTo(20.5f, 6.0f)
                curveToRelative(-2.61f, 0.7f, -5.67f, 1.0f, -8.5f, 1.0f)
                reflectiveCurveToRelative(-5.89f, -0.3f, -8.5f, -1.0f)
                lineTo(3.0f, 8.0f)
                curveToRelative(1.86f, 0.5f, 4.0f, 0.83f, 6.0f, 1.0f)
                verticalLineToRelative(13.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-6.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(9.0f)
                curveToRelative(2.0f, -0.17f, 4.14f, -0.5f, 6.0f, -1.0f)
                lineToRelative(-0.5f, -2.0f)
                close()
                moveTo(12.0f, 6.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                close()
            }
        }
        return _accessibilityNew!!
    }

private var _accessibilityNew: ImageVector? = null
