/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.CellWifi: ImageVector
    get() {
        if (_cellWifi != null) {
            return _cellWifi!!
        }
        _cellWifi = materialIcon(name = "Filled.CellWifi") {
            materialPath {
                moveTo(18.0f, 9.98f)
                lineTo(6.0f, 22.0f)
                horizontalLineToRelative(12.0f)
                horizontalLineToRelative(4.0f)
                verticalLineTo(5.97f)
                lineTo(18.0f, 9.98f)
                close()
                moveTo(20.0f, 20.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-7.22f)
                lineToRelative(2.0f, -2.0f)
                verticalLineTo(20.0f)
                close()
                moveTo(5.22f, 7.22f)
                lineTo(3.93f, 5.93f)
                curveToRelative(3.9f, -3.91f, 10.24f, -3.91f, 14.15f, 0.0f)
                lineToRelative(-1.29f, 1.29f)
                curveTo(13.6f, 4.03f, 8.41f, 4.03f, 5.22f, 7.22f)
                close()
                moveTo(12.93f, 11.07f)
                lineTo(11.0f, 13.0f)
                lineToRelative(-1.93f, -1.93f)
                curveTo(10.14f, 10.01f, 11.86f, 10.01f, 12.93f, 11.07f)
                close()
                moveTo(14.22f, 9.79f)
                curveToRelative(-1.78f, -1.77f, -4.66f, -1.77f, -6.43f, 0.0f)
                lineTo(6.5f, 8.5f)
                curveToRelative(2.48f, -2.48f, 6.52f, -2.48f, 9.0f, 0.0f)
                lineTo(14.22f, 9.79f)
                close()
            }
        }
        return _cellWifi!!
    }

private var _cellWifi: ImageVector? = null
