/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.SmokeFree: ImageVector
    get() {
        if (_smokeFree != null) {
            return _smokeFree!!
        }
        _smokeFree = materialIcon(name = "Filled.SmokeFree") {
            materialPath {
                moveTo(2.0f, 6.0f)
                lineToRelative(6.99f, 7.0f)
                lineTo(2.0f, 13.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(9.99f)
                lineToRelative(7.0f, 7.0f)
                lineToRelative(1.26f, -1.25f)
                lineToRelative(-17.0f, -17.0f)
                close()
                moveTo(20.5f, 13.0f)
                lineTo(22.0f, 13.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-1.5f)
                close()
                moveTo(18.0f, 13.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(3.0f)
                lineTo(18.0f, 16.0f)
                close()
                moveTo(18.85f, 4.88f)
                curveToRelative(0.62f, -0.61f, 1.0f, -1.45f, 1.0f, -2.38f)
                horizontalLineToRelative(-1.5f)
                curveToRelative(0.0f, 1.02f, -0.83f, 1.85f, -1.85f, 1.85f)
                verticalLineToRelative(1.5f)
                curveToRelative(2.24f, 0.0f, 4.0f, 1.83f, 4.0f, 4.07f)
                lineTo(20.5f, 12.0f)
                lineTo(22.0f, 12.0f)
                lineTo(22.0f, 9.92f)
                curveToRelative(0.0f, -2.23f, -1.28f, -4.15f, -3.15f, -5.04f)
                close()
                moveTo(14.5f, 8.7f)
                horizontalLineToRelative(1.53f)
                curveToRelative(1.05f, 0.0f, 1.97f, 0.74f, 1.97f, 2.05f)
                lineTo(18.0f, 12.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-1.59f)
                curveToRelative(0.0f, -1.8f, -1.6f, -3.16f, -3.47f, -3.16f)
                lineTo(14.5f, 7.25f)
                curveToRelative(-1.02f, 0.0f, -1.85f, -0.98f, -1.85f, -2.0f)
                reflectiveCurveToRelative(0.83f, -1.75f, 1.85f, -1.75f)
                lineTo(14.5f, 2.0f)
                curveToRelative(-1.85f, 0.0f, -3.35f, 1.5f, -3.35f, 3.35f)
                reflectiveCurveToRelative(1.5f, 3.35f, 3.35f, 3.35f)
                close()
                moveTo(17.0f, 15.93f)
                lineTo(17.0f, 13.0f)
                horizontalLineToRelative(-2.93f)
                close()
            }
        }
        return _smokeFree!!
    }

private var _smokeFree: ImageVector? = null
