/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Toys: ImageVector
    get() {
        if (_toys != null) {
            return _toys!!
        }
        _toys = materialIcon(name = "Filled.Toys") {
            materialPath {
                moveTo(22.0f, 14.0f)
                curveToRelative(0.0f, -1.95f, -1.4f, -3.57f, -3.25f, -3.92f)
                lineTo(17.4f, 6.05f)
                curveTo(17.0f, 4.82f, 15.85f, 4.0f, 14.56f, 4.0f)
                horizontalLineTo(9.44f)
                curveTo(8.15f, 4.0f, 7.0f, 4.82f, 6.6f, 6.05f)
                lineTo(5.81f, 8.4f)
                lineTo(4.41f, 7.0f)
                lineToRelative(0.29f, -0.29f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(-2.0f, 2.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineTo(3.0f, 8.41f)
                lineToRelative(1.79f, 1.79f)
                curveTo(3.18f, 10.72f, 2.0f, 12.22f, 2.0f, 14.0f)
                curveToRelative(0.0f, 1.5f, 0.83f, 2.79f, 2.05f, 3.48f)
                curveTo(4.28f, 18.9f, 5.51f, 20.0f, 7.0f, 20.0f)
                curveToRelative(1.3f, 0.0f, 2.4f, -0.84f, 2.82f, -2.0f)
                horizontalLineToRelative(4.37f)
                curveToRelative(0.41f, 1.16f, 1.51f, 2.0f, 2.82f, 2.0f)
                curveToRelative(1.49f, 0.0f, 2.72f, -1.1f, 2.95f, -2.52f)
                curveTo(21.17f, 16.79f, 22.0f, 15.5f, 22.0f, 14.0f)
                close()
                moveTo(7.0f, 18.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(7.55f, 18.0f, 7.0f, 18.0f)
                close()
                moveTo(11.0f, 10.0f)
                horizontalLineTo(7.41f)
                lineTo(7.39f, 9.98f)
                lineToRelative(1.1f, -3.3f)
                curveTo(8.63f, 6.27f, 9.01f, 6.0f, 9.44f, 6.0f)
                horizontalLineTo(11.0f)
                verticalLineTo(10.0f)
                close()
                moveTo(13.0f, 6.0f)
                horizontalLineToRelative(1.56f)
                curveToRelative(0.43f, 0.0f, 0.81f, 0.27f, 0.95f, 0.68f)
                lineTo(16.61f, 10.0f)
                horizontalLineTo(13.0f)
                verticalLineTo(6.0f)
                close()
                moveTo(17.0f, 18.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(17.55f, 18.0f, 17.0f, 18.0f)
                close()
            }
        }
        return _toys!!
    }

private var _toys: ImageVector? = null
