/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.DonutSmall: ImageVector
    get() {
        if (_donutSmall != null) {
            return _donutSmall!!
        }
        _donutSmall = materialIcon(name = "Outlined.DonutSmall") {
            materialPath {
                moveTo(14.82f, 11.0f)
                horizontalLineToRelative(7.13f)
                curveToRelative(-0.47f, -4.72f, -4.23f, -8.48f, -8.95f, -8.95f)
                verticalLineToRelative(7.13f)
                curveToRelative(0.85f, 0.31f, 1.51f, 0.97f, 1.82f, 1.82f)
                close()
                moveTo(15.0f, 4.58f)
                curveTo(17.0f, 5.4f, 18.6f, 7.0f, 19.42f, 9.0f)
                horizontalLineToRelative(-3.43f)
                curveToRelative(-0.28f, -0.37f, -0.62f, -0.71f, -0.99f, -0.99f)
                lineTo(15.0f, 4.58f)
                close()
                moveTo(2.0f, 12.0f)
                curveToRelative(0.0f, 5.19f, 3.95f, 9.45f, 9.0f, 9.95f)
                verticalLineToRelative(-7.13f)
                curveTo(9.84f, 14.4f, 9.0f, 13.3f, 9.0f, 12.0f)
                curveToRelative(0.0f, -1.3f, 0.84f, -2.4f, 2.0f, -2.82f)
                lineTo(11.0f, 2.05f)
                curveToRelative(-5.05f, 0.5f, -9.0f, 4.76f, -9.0f, 9.95f)
                close()
                moveTo(9.0f, 4.58f)
                verticalLineToRelative(3.44f)
                curveToRelative(-1.23f, 0.92f, -2.0f, 2.39f, -2.0f, 3.98f)
                curveToRelative(0.0f, 1.59f, 0.77f, 3.06f, 2.0f, 3.99f)
                verticalLineToRelative(3.44f)
                curveTo(6.04f, 18.24f, 4.0f, 15.35f, 4.0f, 12.0f)
                curveToRelative(0.0f, -3.35f, 2.04f, -6.24f, 5.0f, -7.42f)
                close()
                moveTo(13.0f, 14.82f)
                verticalLineToRelative(7.13f)
                curveToRelative(4.72f, -0.47f, 8.48f, -4.23f, 8.95f, -8.95f)
                horizontalLineToRelative(-7.13f)
                curveToRelative(-0.31f, 0.85f, -0.97f, 1.51f, -1.82f, 1.82f)
                close()
                moveTo(15.0f, 15.99f)
                curveToRelative(0.37f, -0.28f, 0.71f, -0.61f, 0.99f, -0.99f)
                horizontalLineToRelative(3.43f)
                curveTo(18.6f, 17.0f, 17.0f, 18.6f, 15.0f, 19.42f)
                verticalLineToRelative(-3.43f)
                close()
            }
        }
        return _donutSmall!!
    }

private var _donutSmall: ImageVector? = null
