/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.FiberNew: ImageVector
    get() {
        if (_fiberNew != null) {
            return _fiberNew!!
        }
        _fiberNew = materialIcon(name = "Outlined.FiberNew") {
            materialPath {
                moveTo(7.25f, 12.5f)
                lineTo(4.75f, 9.0f)
                lineTo(3.5f, 9.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(1.25f)
                verticalLineToRelative(-3.5f)
                lineTo(7.3f, 15.0f)
                horizontalLineToRelative(1.2f)
                lineTo(8.5f, 9.0f)
                lineTo(7.25f, 9.0f)
                close()
                moveTo(9.5f, 15.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(-1.25f)
                lineTo(11.0f, 13.75f)
                verticalLineToRelative(-1.11f)
                horizontalLineToRelative(2.5f)
                verticalLineToRelative(-1.26f)
                lineTo(11.0f, 11.38f)
                verticalLineToRelative(-1.12f)
                horizontalLineToRelative(2.5f)
                lineTo(13.5f, 9.0f)
                horizontalLineToRelative(-4.0f)
                close()
                moveTo(19.25f, 9.0f)
                verticalLineToRelative(4.5f)
                horizontalLineToRelative(-1.12f)
                lineTo(18.13f, 9.99f)
                horizontalLineToRelative(-1.25f)
                verticalLineToRelative(3.52f)
                horizontalLineToRelative(-1.13f)
                lineTo(15.75f, 9.0f)
                lineTo(14.5f, 9.0f)
                verticalLineToRelative(5.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                lineTo(20.5f, 9.0f)
                horizontalLineToRelative(-1.25f)
                close()
            }
        }
        return _fiberNew!!
    }

private var _fiberNew: ImageVector? = null
