/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SafetyDivider: ImageVector
    get() {
        if (_safetyDivider != null) {
            return _safetyDivider!!
        }
        _safetyDivider = materialIcon(name = "Outlined.SafetyDivider") {
            materialPath {
                moveTo(11.0f, 5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(5.0f)
                close()
                moveTo(5.0f, 12.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                curveTo(3.0f, 11.1f, 3.9f, 12.0f, 5.0f, 12.0f)
                close()
                moveTo(7.78f, 13.58f)
                curveTo(6.93f, 13.21f, 5.99f, 13.0f, 5.0f, 13.0f)
                reflectiveCurveToRelative(-1.93f, 0.21f, -2.78f, 0.58f)
                curveTo(1.48f, 13.9f, 1.0f, 14.62f, 1.0f, 15.43f)
                lineTo(1.0f, 16.0f)
                horizontalLineToRelative(8.0f)
                lineToRelative(0.0f, -0.57f)
                curveTo(9.0f, 14.62f, 8.52f, 13.9f, 7.78f, 13.58f)
                close()
                moveTo(19.0f, 12.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                curveTo(17.0f, 11.1f, 17.9f, 12.0f, 19.0f, 12.0f)
                close()
                moveTo(21.78f, 13.58f)
                curveTo(20.93f, 13.21f, 19.99f, 13.0f, 19.0f, 13.0f)
                reflectiveCurveToRelative(-1.93f, 0.21f, -2.78f, 0.58f)
                curveTo(15.48f, 13.9f, 15.0f, 14.62f, 15.0f, 15.43f)
                lineTo(15.0f, 16.0f)
                horizontalLineToRelative(8.0f)
                lineToRelative(0.0f, -0.57f)
                curveTo(23.0f, 14.62f, 22.52f, 13.9f, 21.78f, 13.58f)
                close()
            }
        }
        return _safetyDivider!!
    }

private var _safetyDivider: ImageVector? = null
