/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AutoFixHigh: ImageVector
    get() {
        if (_autoFixHigh != null) {
            return _autoFixHigh!!
        }
        _autoFixHigh = materialIcon(name = "Rounded.AutoFixHigh") {
            materialPath {
                moveTo(20.45f, 6.0f)
                lineToRelative(0.49f, -1.06f)
                lineTo(22.0f, 4.45f)
                curveToRelative(0.39f, -0.18f, 0.39f, -0.73f, 0.0f, -0.91f)
                lineToRelative(-1.06f, -0.49f)
                lineTo(20.45f, 2.0f)
                curveToRelative(-0.18f, -0.39f, -0.73f, -0.39f, -0.91f, 0.0f)
                lineToRelative(-0.49f, 1.06f)
                lineTo(18.0f, 3.55f)
                curveToRelative(-0.39f, 0.18f, -0.39f, 0.73f, 0.0f, 0.91f)
                lineToRelative(1.06f, 0.49f)
                lineTo(19.55f, 6.0f)
                curveTo(19.72f, 6.39f, 20.28f, 6.39f, 20.45f, 6.0f)
                close()
            }
            materialPath {
                moveTo(8.95f, 6.0f)
                lineToRelative(0.49f, -1.06f)
                lineToRelative(1.06f, -0.49f)
                curveToRelative(0.39f, -0.18f, 0.39f, -0.73f, 0.0f, -0.91f)
                lineTo(9.44f, 3.06f)
                lineTo(8.95f, 2.0f)
                curveTo(8.78f, 1.61f, 8.22f, 1.61f, 8.05f, 2.0f)
                lineTo(7.56f, 3.06f)
                lineTo(6.5f, 3.55f)
                curveToRelative(-0.39f, 0.18f, -0.39f, 0.73f, 0.0f, 0.91f)
                lineToRelative(1.06f, 0.49f)
                lineTo(8.05f, 6.0f)
                curveTo(8.22f, 6.39f, 8.78f, 6.39f, 8.95f, 6.0f)
                close()
            }
            materialPath {
                moveTo(19.55f, 13.5f)
                lineToRelative(-0.49f, 1.06f)
                lineTo(18.0f, 15.05f)
                curveToRelative(-0.39f, 0.18f, -0.39f, 0.73f, 0.0f, 0.91f)
                lineToRelative(1.06f, 0.49f)
                lineToRelative(0.49f, 1.06f)
                curveToRelative(0.18f, 0.39f, 0.73f, 0.39f, 0.91f, 0.0f)
                lineToRelative(0.49f, -1.06f)
                lineTo(22.0f, 15.95f)
                curveToRelative(0.39f, -0.18f, 0.39f, -0.73f, 0.0f, -0.91f)
                lineToRelative(-1.06f, -0.49f)
                lineToRelative(-0.49f, -1.06f)
                curveTo(20.28f, 13.11f, 19.72f, 13.11f, 19.55f, 13.5f)
                close()
            }
            materialPath {
                moveTo(17.71f, 9.12f)
                lineToRelative(-2.83f, -2.83f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineTo(2.29f, 17.46f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(2.83f, 2.83f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(11.17f, -11.17f)
                curveTo(18.1f, 10.15f, 18.1f, 9.51f, 17.71f, 9.12f)
                close()
                moveTo(14.21f, 11.21f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(1.38f, -1.38f)
                lineToRelative(1.41f, 1.41f)
                lineTo(14.21f, 11.21f)
                close()
            }
        }
        return _autoFixHigh!!
    }

private var _autoFixHigh: ImageVector? = null
