/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ChargingStation: ImageVector
    get() {
        if (_chargingStation != null) {
            return _chargingStation!!
        }
        _chargingStation = materialIcon(name = "Rounded.ChargingStation") {
            materialPath {
                moveTo(17.0f, 1.0f)
                horizontalLineTo(7.0f)
                curveTo(5.9f, 1.0f, 5.0f, 1.9f, 5.0f, 3.0f)
                verticalLineToRelative(18.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(3.0f)
                curveTo(19.0f, 1.9f, 18.1f, 1.0f, 17.0f, 1.0f)
                close()
                moveTo(17.0f, 18.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(10.0f)
                verticalLineTo(18.0f)
                close()
                moveTo(12.5f, 11.0f)
                verticalLineTo(9.12f)
                curveToRelative(0.0f, -0.53f, -0.71f, -0.7f, -0.95f, -0.22f)
                lineToRelative(-1.69f, 3.38f)
                curveTo(9.7f, 12.61f, 9.94f, 13.0f, 10.31f, 13.0f)
                horizontalLineToRelative(1.19f)
                verticalLineToRelative(1.88f)
                curveToRelative(0.0f, 0.53f, 0.71f, 0.7f, 0.95f, 0.22f)
                lineToRelative(1.69f, -3.38f)
                curveTo(14.3f, 11.39f, 14.06f, 11.0f, 13.69f, 11.0f)
                horizontalLineTo(12.5f)
                close()
            }
        }
        return _chargingStation!!
    }

private var _chargingStation: ImageVector? = null
