/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Earbuds: ImageVector
    get() {
        if (_earbuds != null) {
            return _earbuds!!
        }
        _earbuds = materialIcon(name = "Rounded.Earbuds") {
            materialPath {
                moveTo(6.2f, 3.01f)
                curveTo(4.44f, 2.89f, 3.0f, 4.42f, 3.0f, 6.19f)
                lineTo(3.0f, 16.0f)
                curveToRelative(0.0f, 2.76f, 2.24f, 5.0f, 5.0f, 5.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(2.76f, 0.0f, 5.0f, -2.24f, 5.0f, -5.0f)
                verticalLineTo(8.0f)
                curveToRelative(0.0f, -1.66f, 1.34f, -3.0f, 3.0f, -3.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, 1.34f, 3.0f, 3.0f)
                verticalLineToRelative(7.0f)
                lineToRelative(-0.83f, 0.0f)
                curveToRelative(-1.61f, 0.0f, -3.06f, 1.18f, -3.17f, 2.79f)
                curveToRelative(-0.12f, 1.69f, 1.16f, 3.1f, 2.8f, 3.21f)
                curveToRelative(1.76f, 0.12f, 3.2f, -1.42f, 3.2f, -3.18f)
                lineTo(21.0f, 8.0f)
                curveToRelative(0.0f, -2.76f, -2.24f, -5.0f, -5.0f, -5.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, 2.24f, -5.0f, 5.0f)
                verticalLineToRelative(8.0f)
                curveToRelative(0.0f, 1.66f, -1.34f, 3.0f, -3.0f, 3.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, -1.34f, -3.0f, -3.0f)
                verticalLineTo(9.0f)
                lineToRelative(0.83f, 0.0f)
                curveTo(7.44f, 9.0f, 8.89f, 7.82f, 9.0f, 6.21f)
                curveTo(9.11f, 4.53f, 7.83f, 3.11f, 6.2f, 3.01f)
                close()
            }
        }
        return _earbuds!!
    }

private var _earbuds: ImageVector? = null
