/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.LocalLibrary: ImageVector
    get() {
        if (_localLibrary != null) {
            return _localLibrary!!
        }
        _localLibrary = materialIcon(name = "Rounded.LocalLibrary") {
            materialPath {
                moveTo(12.0f, 11.55f)
                curveToRelative(-1.82f, -1.7f, -4.12f, -2.89f, -6.68f, -3.35f)
                curveTo(4.11f, 7.99f, 3.0f, 8.95f, 3.0f, 10.18f)
                verticalLineToRelative(6.24f)
                curveToRelative(0.0f, 1.68f, 0.72f, 2.56f, 1.71f, 2.69f)
                curveToRelative(2.5f, 0.32f, 4.77f, 1.35f, 6.63f, 2.87f)
                curveToRelative(0.35f, 0.29f, 0.92f, 0.32f, 1.27f, 0.04f)
                curveToRelative(1.87f, -1.53f, 4.16f, -2.58f, 6.68f, -2.9f)
                curveToRelative(0.94f, -0.13f, 1.71f, -1.06f, 1.71f, -2.02f)
                verticalLineToRelative(-6.92f)
                curveToRelative(0.0f, -1.23f, -1.11f, -2.19f, -2.32f, -1.98f)
                curveToRelative(-2.56f, 0.46f, -4.86f, 1.65f, -6.68f, 3.35f)
                close()
                moveTo(12.0f, 8.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                reflectiveCurveToRelative(-1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveToRelative(-3.0f, 1.34f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.34f, 3.0f, 3.0f, 3.0f)
                close()
            }
        }
        return _localLibrary!!
    }

private var _localLibrary: ImageVector? = null
