/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.PortableWifiOff: ImageVector
    get() {
        if (_portableWifiOff != null) {
            return _portableWifiOff!!
        }
        _portableWifiOff = materialIcon(name = "Rounded.PortableWifiOff") {
            materialPath {
                moveTo(2.71f, 3.07f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineTo(4.1f, 5.87f)
                curveTo(2.79f, 7.57f, 2.0f, 9.69f, 2.0f, 12.0f)
                curveToRelative(0.0f, 3.3f, 1.6f, 6.22f, 4.06f, 8.04f)
                curveToRelative(0.48f, 0.35f, 1.16f, 0.21f, 1.46f, -0.31f)
                curveToRelative(0.25f, -0.43f, 0.14f, -0.99f, -0.26f, -1.29f)
                curveTo(5.29f, 16.98f, 4.0f, 14.65f, 4.0f, 12.0f)
                curveToRelative(0.0f, -1.76f, 0.57f, -3.38f, 1.53f, -4.69f)
                lineToRelative(1.43f, 1.44f)
                curveTo(6.36f, 9.68f, 6.0f, 10.8f, 6.0f, 12.0f)
                curveToRelative(0.0f, 1.8f, 0.8f, 3.41f, 2.06f, 4.51f)
                curveToRelative(0.46f, 0.4f, 1.19f, 0.25f, 1.5f, -0.28f)
                lineToRelative(0.01f, -0.01f)
                curveToRelative(0.24f, -0.42f, 0.13f, -0.94f, -0.23f, -1.26f)
                curveTo(8.52f, 14.23f, 8.0f, 13.18f, 8.0f, 12.0f)
                curveToRelative(0.0f, -0.65f, 0.17f, -1.25f, 0.44f, -1.79f)
                lineToRelative(1.58f, 1.58f)
                lineTo(10.0f, 12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                lineToRelative(0.21f, -0.02f)
                lineToRelative(6.81f, 6.81f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(4.13f, 3.07f)
                curveToRelative(-0.39f, -0.39f, -1.03f, -0.39f, -1.42f, 0.0f)
                close()
                moveTo(17.71f, 13.82f)
                curveToRelative(0.18f, -0.57f, 0.29f, -1.19f, 0.29f, -1.82f)
                curveToRelative(0.0f, -3.31f, -2.69f, -6.0f, -6.0f, -6.0f)
                curveToRelative(-0.63f, 0.0f, -1.25f, 0.11f, -1.82f, 0.29f)
                lineToRelative(1.72f, 1.72f)
                curveToRelative(0.03f, 0.0f, 0.06f, -0.01f, 0.1f, -0.01f)
                curveToRelative(2.21f, 0.0f, 4.0f, 1.79f, 4.0f, 4.0f)
                curveToRelative(0.0f, 0.04f, -0.01f, 0.07f, -0.01f, 0.11f)
                lineToRelative(1.72f, 1.71f)
                close()
                moveTo(12.0f, 4.0f)
                curveToRelative(4.42f, 0.0f, 8.0f, 3.58f, 8.0f, 8.0f)
                curveToRelative(0.0f, 1.2f, -0.29f, 2.32f, -0.77f, 3.35f)
                lineToRelative(1.49f, 1.49f)
                curveTo(21.53f, 15.4f, 22.0f, 13.76f, 22.0f, 12.0f)
                curveToRelative(0.0f, -5.52f, -4.48f, -10.0f, -10.0f, -10.0f)
                curveToRelative(-1.76f, 0.0f, -3.4f, 0.48f, -4.84f, 1.28f)
                lineToRelative(1.48f, 1.48f)
                curveTo(9.66f, 4.28f, 10.8f, 4.0f, 12.0f, 4.0f)
                close()
            }
        }
        return _portableWifiOff!!
    }

private var _portableWifiOff: ImageVector? = null
