/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.TheaterComedy: ImageVector
    get() {
        if (_theaterComedy != null) {
            return _theaterComedy!!
        }
        _theaterComedy = materialIcon(name = "Rounded.TheaterComedy") {
            materialPath {
                moveTo(21.0f, 2.0f)
                horizontalLineToRelative(-8.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(3.5f)
                horizontalLineToRelative(1.5f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(4.95f)
                curveToRelative(1.04f, 0.48f, 2.24f, 0.68f, 3.5f, 0.47f)
                curveToRelative(2.93f, -0.49f, 5.0f, -3.17f, 5.0f, -6.14f)
                verticalLineTo(4.0f)
                curveTo(23.0f, 2.9f, 22.1f, 2.0f, 21.0f, 2.0f)
                close()
                moveTo(14.0f, 6.5f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveTo(14.0f, 7.05f, 14.0f, 6.5f)
                close()
                moveTo(18.85f, 10.88f)
                horizontalLineToRelative(-3.72f)
                curveToRelative(-0.38f, 0.0f, -0.63f, -0.41f, -0.44f, -0.75f)
                curveTo(15.08f, 9.47f, 15.96f, 9.0f, 16.99f, 9.0f)
                reflectiveCurveToRelative(1.91f, 0.47f, 2.3f, 1.14f)
                curveTo(19.48f, 10.47f, 19.23f, 10.88f, 18.85f, 10.88f)
                close()
                moveTo(19.0f, 7.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(19.55f, 7.5f, 19.0f, 7.5f)
                close()
            }
            materialPath {
                moveTo(11.0f, 9.0f)
                horizontalLineTo(3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(4.79f)
                curveToRelative(0.0f, 3.05f, 2.19f, 5.77f, 5.21f, 6.16f)
                curveTo(9.87f, 22.42f, 13.0f, 19.57f, 13.0f, 16.0f)
                verticalLineToRelative(-5.0f)
                curveTo(13.0f, 9.9f, 12.1f, 9.0f, 11.0f, 9.0f)
                close()
                moveTo(4.0f, 13.5f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveTo(4.0f, 14.05f, 4.0f, 13.5f)
                close()
                moveTo(9.3f, 16.75f)
                curveToRelative(-0.38f, 0.67f, -1.27f, 1.14f, -2.3f, 1.14f)
                reflectiveCurveToRelative(-1.91f, -0.47f, -2.3f, -1.14f)
                curveTo(4.51f, 16.41f, 4.76f, 16.0f, 5.14f, 16.0f)
                horizontalLineToRelative(3.72f)
                curveTo(9.24f, 16.0f, 9.49f, 16.41f, 9.3f, 16.75f)
                close()
                moveTo(9.0f, 14.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(9.55f, 14.5f, 9.0f, 14.5f)
                close()
            }
        }
        return _theaterComedy!!
    }

private var _theaterComedy: ImageVector? = null
