/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Volcano: ImageVector
    get() {
        if (_volcano != null) {
            return _volcano!!
        }
        _volcano = materialIcon(name = "Rounded.Volcano") {
            materialPath {
                moveTo(16.49f, 8.0f)
                horizontalLineToRelative(-4.14f)
                curveToRelative(-0.82f, 0.0f, -1.55f, 0.5f, -1.86f, 1.26f)
                lineTo(9.0f, 13.0f)
                horizontalLineTo(7.3f)
                curveToRelative(-0.79f, 0.0f, -1.51f, 0.47f, -1.83f, 1.19f)
                lineToRelative(-2.22f, 5.0f)
                curveTo(2.66f, 20.51f, 3.63f, 22.0f, 5.08f, 22.0f)
                horizontalLineToRelative(14.27f)
                curveToRelative(1.33f, 0.0f, 2.29f, -1.27f, 1.92f, -2.55f)
                lineToRelative(-2.86f, -10.0f)
                curveTo(18.17f, 8.59f, 17.38f, 8.0f, 16.49f, 8.0f)
                close()
            }
            materialPath {
                moveTo(14.0f, 1.0f)
                lineTo(14.0f, 1.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(2.0f)
                curveTo(15.0f, 1.45f, 14.55f, 1.0f, 14.0f, 1.0f)
                close()
            }
            materialPath {
                moveTo(19.66f, 3.34f)
                lineTo(19.66f, 3.34f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(-1.41f, 1.41f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(1.41f, -1.41f)
                curveTo(20.05f, 4.37f, 20.05f, 3.73f, 19.66f, 3.34f)
                close()
            }
            materialPath {
                moveTo(11.17f, 4.76f)
                lineTo(9.76f, 3.34f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(1.41f, 1.41f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveTo(11.56f, 5.78f, 11.56f, 5.15f, 11.17f, 4.76f)
                close()
            }
        }
        return _volcano!!
    }

private var _volcano: ImageVector? = null
