/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.AppBlocking: ImageVector
    get() {
        if (_appBlocking != null) {
            return _appBlocking!!
        }
        _appBlocking = materialIcon(name = "Sharp.AppBlocking") {
            materialPath {
                moveTo(18.0f, 8.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, 1.79f, -4.0f, 4.0f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                reflectiveCurveToRelative(4.0f, -1.79f, 4.0f, -4.0f)
                curveTo(22.0f, 9.79f, 20.21f, 8.0f, 18.0f, 8.0f)
                close()
                moveTo(15.5f, 12.0f)
                curveToRelative(0.0f, -1.38f, 1.12f, -2.5f, 2.5f, -2.5f)
                curveToRelative(0.42f, 0.0f, 0.8f, 0.11f, 1.15f, 0.29f)
                lineToRelative(-3.36f, 3.36f)
                curveTo(15.61f, 12.8f, 15.5f, 12.42f, 15.5f, 12.0f)
                close()
                moveTo(18.0f, 14.5f)
                curveToRelative(-0.42f, 0.0f, -0.8f, -0.11f, -1.15f, -0.29f)
                lineToRelative(3.36f, -3.36f)
                curveToRelative(0.18f, 0.35f, 0.29f, 0.73f, 0.29f, 1.15f)
                curveTo(20.5f, 13.38f, 19.38f, 14.5f, 18.0f, 14.5f)
                close()
            }
            materialPath {
                moveTo(19.0f, 23.0f)
                verticalLineToRelative(-6.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(0.94f)
                lineTo(5.0f, 1.0f)
                verticalLineToRelative(22.0f)
                horizontalLineTo(19.0f)
                close()
            }
        }
        return _appBlocking!!
    }

private var _appBlocking: ImageVector? = null
