/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.Sharp.FormatTextdirectionRToL",
    ReplaceWith( "Icons.AutoMirrored.Sharp.FormatTextdirectionRToL",
            "androidx.compose.material.icons.automirrored.sharp.FormatTextdirectionRToL"),
)
public val Icons.Sharp.FormatTextdirectionRToL: ImageVector
    get() {
        if (_formatTextdirectionRToL != null) {
            return _formatTextdirectionRToL!!
        }
        _formatTextdirectionRToL = materialIcon(name = "Sharp.FormatTextdirectionRToL") {
            materialPath {
                moveTo(10.0f, 10.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(2.0f)
                lineTo(12.0f, 4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(11.0f)
                horizontalLineToRelative(2.0f)
                lineTo(16.0f, 4.0f)
                horizontalLineToRelative(2.0f)
                lineTo(18.0f, 2.0f)
                horizontalLineToRelative(-8.0f)
                curveTo(7.79f, 2.0f, 6.0f, 3.79f, 6.0f, 6.0f)
                reflectiveCurveToRelative(1.79f, 4.0f, 4.0f, 4.0f)
                close()
                moveTo(8.0f, 17.0f)
                verticalLineToRelative(-3.0f)
                lineToRelative(-4.0f, 4.0f)
                lineToRelative(4.0f, 4.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(-2.0f)
                lineTo(8.0f, 17.0f)
                close()
            }
        }
        return _formatTextdirectionRToL!!
    }

private var _formatTextdirectionRToL: ImageVector? = null
