/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.MediaBluetoothOff: ImageVector
    get() {
        if (_mediaBluetoothOff != null) {
            return _mediaBluetoothOff!!
        }
        _mediaBluetoothOff = materialIcon(name = "Sharp.MediaBluetoothOff") {
            materialPath {
                moveTo(9.0f, 6.17f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(1.17f)
                lineTo(9.0f, 6.17f)
                close()
                moveTo(19.42f, 15.0f)
                lineTo(22.0f, 17.57f)
                lineToRelative(-0.8f, 0.8f)
                lineToRelative(-6.78f, -6.78f)
                lineToRelative(0.8f, -0.8f)
                lineToRelative(2.75f, 2.75f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(0.6f)
                lineTo(22.0f, 12.43f)
                lineTo(19.42f, 15.0f)
                close()
                moveTo(19.17f, 13.55f)
                lineToRelative(1.13f, -1.13f)
                lineToRelative(-1.13f, -1.13f)
                verticalLineTo(13.55f)
                close()
                moveTo(17.21f, 17.21f)
                lineToRelative(3.98f, 3.98f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(-3.98f, -3.98f)
                lineToRelative(-0.58f, 0.58f)
                lineToRelative(-0.85f, -0.85f)
                lineToRelative(0.58f, -0.58f)
                lineTo(11.0f, 13.83f)
                verticalLineTo(17.0f)
                curveToRelative(0.0f, 2.21f, -1.78f, 4.0f, -3.99f, 4.0f)
                reflectiveCurveTo(3.0f, 19.21f, 3.0f, 17.0f)
                reflectiveCurveToRelative(1.79f, -4.0f, 4.01f, -4.0f)
                curveToRelative(0.73f, 0.0f, 1.41f, 0.21f, 2.0f, 0.55f)
                verticalLineToRelative(-1.72f)
                lineTo(1.39f, 4.22f)
                lineTo(2.8f, 2.81f)
                lineToRelative(13.56f, 13.56f)
                lineTo(17.21f, 17.21f)
                close()
            }
        }
        return _mediaBluetoothOff!!
    }

private var _mediaBluetoothOff: ImageVector? = null
